#include "TestFramework.h"
#include "TestConfig.h"
#include "htio2/FastqIO.h"
#include "htio2/FastqSeq.h"

void TestFramework::content()
{
    const char* cmd = "../src/ht2-rename --quiet -i " TEST_SOURCE_DIR "/test1.fastq.gz -o rename --prefix aaa_ --suffix _bbb";
    ok(!system(cmd), cmd);

    htio2::FastqIO fh("rename.fastq.gz", htio2::READ, htio2::COMPRESS_GZIP);
    htio2::FastqSeq seq;

    size_t n = 0;
    while (fh.next_seq(seq))
    {
        n++;
        if (n==1)
        {
            IS(seq.id, "aaa_1_bbb");
            IS(seq.seq,     "AGCCTACGGGAGGCAGCAGTGAGGAATATTGGTCAATGGACGAGAGTCTGAACCAGCCAAGTAGCGTGAAGGATGAAGGTCCTACGGATTGTAAACTTCTTTTATAAGGGAATAAACCCTCCCACGTGTGGGAGCTTGTATGTACCTTAT");
            IS(seq.quality, "=?@DFADDHHAHDGGBGGGIGHBEGGHEI>FGIIGCGGCH3?@FEB@@@FGICHG==AHFFEFEEDDDDDDC<>A>A:ACDCC>C<@BB>C@ACC@CACAC@ACCDDDCA?ABCAC@9@AA8??8><ADB<>B8<B:C?>@>>34>:@CD");
        }
        else if (n==2)
        {
            IS(seq.id, "aaa_2_bbb");
            IS(seq.seq,     "AGCCTACGGGAGGCAGCAGTGGGGAATATTGCACAATGGAGGAAACTCTGATGCAGCGACGCCGCGTGAGTGAAGAAGTGGTTCGCTATGTAAAGCTCTATCAGCAGGGAAGATNNTGACGGTACCTGACTAAGAAGCTCCGGCTAACTA");
            IS(seq.quality, "@@CFFDFFGHHHHJJHFHGHHGIIHIJJJJIHHJJJJGIGIJHIJGIICFC@ECEHAB@4=;@DBB8B@B:@:>C>>CCCD:?CDDDDBDEEEDCCDCDDCCCC@@ADD?BDBD##++8?@B9A9CDCCCCCDDCDCCD@C>BBDDCDDD");
        }
        else if (n==100)
        {
            IS(seq.id, "aaa_100_bbb");
            IS(seq.seq,     "ATCGCAAATCATGGTGGGGATGATACGGCGTTTCATTGCGGAGCAGGAAATTGTTATGTTCTTATCAGGAGATTATAATTGGCCTGACAAATGGATGTGATTTATTTATTGGGCTCAATTGGGCTAGGTTGGGGATCTTCATTTGTCCAC");
            IS(seq.quality, "@<BFFFFFHGHHHJCFGIIFIJIGJJJJJJIJJGIIJJJJJJHFFFFFCCEDECDDEDFEEEDCDCCDDABDDCDDEEEEDDDDDBCDDDDDDD(:@AACDDDDEDDDEDDDDBDAACCDCDDDDBDDCDDDDD0<BDCDEEEEEE@CDD");
        }
    }
}
