/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;

public class FASTAReader {
    private String fileName;
    private String sequence;
    private String header;
    private String nextHeader;
    private BufferedReader inputFile;

    public FASTAReader(String string) {
        this.fileName = string;
        this.sequence = "";
        this.nextHeader = "";
    }

    public boolean isFASTA() {
        String string = "";
        try {
            this.inputFile = new BufferedReader(new FileReader(this.fileName));
            string = this.inputFile.readLine();
            if (string == null) {
                this.inputFile.close();
                return false;
            }
            if (string.charAt(0) != '>') {
                this.inputFile.close();
                return false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.nextHeader = string;
        this.sequence = "";
        return true;
    }

    public void readASeq() {
        this.header = "";
        this.sequence = "";
        if (this.nextHeader == null) {
            return;
        }
        if (this.nextHeader == "") {
            return;
        }
        try {
            this.header = this.nextHeader;
            StringBuffer stringBuffer = new StringBuffer();
            String string = this.inputFile.readLine();
            while (string != null && string.length() > 0 && string.charAt(0) != '>') {
                stringBuffer.append(string);
                string = this.inputFile.readLine();
            }
            while (string != null && string.length() == 0) {
                string = this.inputFile.readLine();
            }
            this.nextHeader = string;
            this.sequence = stringBuffer.toString();
            if (string == null) {
                this.inputFile.close();
            }
        }
        catch (Exception exception) {
            System.out.println("reading file error, nextHeader " + this.nextHeader);
            exception.printStackTrace();
        }
    }

    public String getSequence() {
        return this.sequence;
    }

    public String getHeader() {
        return this.header.substring(1, this.header.length());
    }
}

