/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class CRISPR {
    private Vector repeats;
    private int repeatLength;

    public CRISPR() {
        this.repeats = new Vector();
        this.repeatLength = 0;
    }

    public CRISPR(Vector vector, int n) {
        this.repeats = vector;
        this.repeatLength = n;
    }

    public Vector repeats() {
        return this.repeats;
    }

    public int repeatLength() {
        return this.repeatLength;
    }

    public void setRepeats(Vector vector) {
        this.repeats = vector;
    }

    public void setRepeatLength(int n) {
        this.repeatLength = n;
    }

    public int repeatSpacing(int n, int n2) {
        return Math.abs(this.repeatAt(n2) - this.repeatAt(n));
    }

    public void addRepeat(int n) {
        this.repeats.addElement(new Integer(n));
    }

    public void insertRepeatAt(int n, int n2) {
        this.repeats.insertElementAt(new Integer(n), n2);
    }

    public void setRepeatAt(int n, int n2) {
        this.repeats.setElementAt(new Integer(n), n2);
    }

    public void removeRepeat(int n) {
        this.repeats.removeElement(new Integer(n));
    }

    public int repeatAt(int n) {
        return (Integer)this.repeats.elementAt(n);
    }

    public int start() {
        return (Integer)this.repeats.firstElement();
    }

    public int end() {
        int n = (Integer)this.repeats.lastElement();
        return n + this.repeatLength - 1;
    }

    public int firstRepeat() {
        return (Integer)this.repeats.elementAt(0);
    }

    public int lastRepeat() {
        return (Integer)this.repeats.lastElement();
    }

    public int numRepeats() {
        return this.repeats.size();
    }

    public int numSpacers() {
        return this.numRepeats() - 1;
    }

    public String repeatStringAt(int n) {
        int n2;
        int n3 = (Integer)this.repeats.elementAt(n);
        int n4 = n3 + this.repeatLength - 1;
        if (n3 < 0) {
            n3 = 0;
        }
        if ((n2 = n4 + 1) > DNASequence.seq.length()) {
            n2 = DNASequence.seq.length();
        }
        return DNASequence.seq.substring(n3, n2);
    }

    public String getConsensus() {
        String string = "";
        for (int i = 0; i < this.repeatLength; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < this.repeats.size(); ++j) {
                int n5 = this.repeatAt(j) + i;
                int n6 = n5 < 0 || n5 >= DNASequence.seq.length() ? 45 : (int)DNASequence.seq.charAt(n5);
                if (n6 == 65) {
                    ++n4;
                }
                if (n6 == 67) {
                    ++n2;
                }
                if (n6 == 84) {
                    ++n3;
                }
                if (n6 != 71) continue;
                ++n;
            }
            char c = n4 >= n2 && n4 >= n3 && n4 >= n ? (char)'A' : (n2 >= n4 && n2 >= n3 && n2 >= n ? (char)'C' : (n3 >= n2 && n3 >= n4 && n3 >= n ? (char)'T' : 'G'));
            string = string + c;
        }
        return string;
    }

    public String spacerStringAt(int n) {
        int n2 = (Integer)this.repeats.elementAt(n) + this.repeatLength - 1;
        int n3 = (Integer)this.repeats.elementAt(n + 1);
        int n4 = n2 + 1;
        int n5 = n3 - 1;
        return DNASequence.seq.substring(n4, n5 + 1);
    }

    public int averageSpacerLength() {
        int n = 0;
        for (int i = 0; i < this.numSpacers(); ++i) {
            n += this.spacerStringAt(i).length();
        }
        return n / this.numSpacers();
    }

    public int averageRepeatLength() {
        int n = 0;
        for (int i = 0; i < this.numRepeats(); ++i) {
            n += this.repeatStringAt(i).length();
        }
        return n / this.numRepeats();
    }

    public int getRepeatLength() {
        if (this.repeatAt(0) >= 0) {
            return this.repeatStringAt(0).length();
        }
        return this.repeatStringAt(1).length();
    }

    public String toString() {
        int n;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        string = string + "POSITION\tREPEAT\t\t\t\tSPACER\n";
        string = string + "--------\t";
        for (n = 0; n < this.repeatLength(); ++n) {
            string = string + "-";
        }
        string = string + "\t";
        for (n = 0; n < this.averageSpacerLength(); ++n) {
            string = string + "-";
        }
        string = string + "\n";
        for (n = 0; n < this.numRepeats(); ++n) {
            String string5 = "";
            for (int i = this.repeatAt(n); i < 0; ++i) {
                string5 = string5 + "-";
            }
            String string6 = "";
            if (string5 == "") {
                String string7 = this.repeatStringAt(n);
                for (int i = string7.length(); i < this.repeatLength(); ++i) {
                    string6 = string6 + "-";
                }
            }
            string = string + (this.repeatAt(n) + 1) + "\t\t" + string5 + this.repeatStringAt(n) + string6 + "\t";
            if (n >= this.numSpacers()) continue;
            string2 = string3;
            string3 = this.spacerStringAt(n);
            string = string + string3;
            string = string + "\t[ " + this.repeatStringAt(n).length() + ", " + this.spacerStringAt(n).length() + " ]";
            string = string + "\n";
        }
        string = string + "\n--------\t";
        for (n = 0; n < this.repeatLength(); ++n) {
            string = string + "-";
        }
        string = string + "\t";
        for (n = 0; n < this.averageSpacerLength(); ++n) {
            string = string + "-";
        }
        string = string + "\n";
        string = string + "Repeat-con\t" + this.getConsensus() + "\n";
        return string;
    }
}

