/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Vector;

public class CRISPRFinder {
    private String inputFileName;
    private String outputFileName;
    private int screenDisplay;
    private int minNumRepeats;
    private int minRepeatLength;
    private int maxRepeatLength;
    private int minSpacerLength;
    private int maxSpacerLength;
    private int searchWindowLength;
    private PrintStream out;
    long totseq = 0L;
    long totbase = 0L;
    long totseqhit = 0L;
    DNASequence sequence = null;
    int sequenceLength = 0;

    public CRISPRFinder(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.inputFileName = string;
        this.outputFileName = string2;
        this.screenDisplay = n;
        this.minNumRepeats = n2;
        this.minRepeatLength = n3;
        this.maxRepeatLength = n4;
        this.minSpacerLength = n5;
        this.maxSpacerLength = n6;
        this.searchWindowLength = n7;
    }

    public void goCRISPRFinder() {
        File file = new File(this.inputFileName);
        String string = "";
        long l = System.currentTimeMillis();
        if (file.exists()) {
            System.out.println("\n\nReading file " + file.getPath());
            FASTAReader fASTAReader = new FASTAReader(file.getPath());
            if (this.screenDisplay == 1) {
                this.out = System.out;
            } else {
                if (this.outputFileName.equals("")) {
                    this.outputFileName = "a.out";
                }
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.outputFileName);
                    this.out = new PrintStream(fileOutputStream);
                }
                catch (Exception exception) {
                    System.out.println("Error processing output file: 2\n");
                }
            }
            if (fASTAReader.isFASTA()) {
                fASTAReader.readASeq();
                string = fASTAReader.getSequence();
                while (string != "") {
                    ++this.totseq;
                    this.totbase += (long)fASTAReader.getSequence().length();
                    this.sequence = new DNASequence(fASTAReader.getSequence(), fASTAReader.getHeader());
                    try {
                        this.findRepeats();
                    }
                    catch (Exception exception) {
                        System.out.println("Error processing sequence: " + this.sequence.getName());
                    }
                    fASTAReader.readASeq();
                    string = fASTAReader.getSequence();
                }
            } else {
                System.out.println("Not a valid FASTA file:  " + file.getPath());
            }
            long l2 = System.currentTimeMillis();
            this.out.print("Total sequences checked: " + this.totseq + "\n");
            this.out.print("Total bases checked: " + this.totbase + "\n");
            this.out.print("Total sequences with predicted CRISPR: " + this.totseqhit + "\n");
            this.out.print("Time used: " + (l2 - l) + " ms\n\n");
            this.out.close();
        } else {
            System.out.println("File name does not exist:  " + file.getPath());
        }
    }

    private void findRepeats() {
        Object object;
        Vector<CRISPR> vector = new Vector<CRISPR>();
        this.sequenceLength = this.sequence.length();
        boolean bl = false;
        if (this.searchWindowLength < 6 || this.searchWindowLength > 9) {
            this.searchWindowLength = 8;
        }
        double d = 0.62;
        int n = 12;
        int n2 = 30;
        int n3 = this.minRepeatLength - (2 * this.searchWindowLength - 1);
        if (n3 < 1) {
            n3 = 1;
        }
        SearchUtil searchUtil = new SearchUtil();
        int n4 = this.sequenceLength - this.maxRepeatLength - this.maxSpacerLength - this.searchWindowLength;
        for (int i = 0; i <= n4; i += n3) {
            int n5;
            String string;
            int n6;
            CRISPR cRISPR = new CRISPR();
            int n7 = i + this.minRepeatLength + this.minSpacerLength;
            int n8 = i + this.maxRepeatLength + this.maxSpacerLength + this.searchWindowLength;
            if (n8 > this.sequenceLength) {
                n8 = this.sequenceLength;
            }
            if (n8 < n7) {
                n8 = n7;
            }
            if ((n6 = searchUtil.boyer_mooreSearch((String)(object = this.sequence.substring(n7, n8)), string = this.sequence.substring(i, i + this.searchWindowLength))) >= 0) {
                cRISPR.addRepeat(i);
                cRISPR.addRepeat(n7 + n6);
                cRISPR = CRISPRUtil.scanRight(cRISPR, string, this.minSpacerLength, 24, searchUtil);
            }
            if (cRISPR.numRepeats() < this.minNumRepeats || (n5 = (cRISPR = CRISPRUtil.getActualRepeatLength(cRISPR, this.searchWindowLength, this.minSpacerLength)).repeatLength()) < this.minRepeatLength || n5 > this.maxRepeatLength || !CRISPRUtil.hasNonRepeatingSpacers(cRISPR, d) || !CRISPRUtil.hasSimilarlySizedSpacers(cRISPR, n, n2)) continue;
            int n9 = cRISPR.numRepeats();
            cRISPR = CRISPRUtil.checkFlank("left", cRISPR, this.minSpacerLength, 30, d, 0.7);
            cRISPR = CRISPRUtil.checkFlank("right", cRISPR, this.minSpacerLength, 30, d, 0.7);
            int n10 = (cRISPR = CRISPRUtil.trim(cRISPR, this.minRepeatLength)).numRepeats();
            if (n10 > n9) {
                CRISPR cRISPR2 = CRISPRUtil.getActualRepeatLength(cRISPR, cRISPR.repeatLength(), this.minSpacerLength);
                if (cRISPR2.repeatLength() > cRISPR.repeatLength()) {
                    vector.addElement(cRISPR2);
                } else {
                    vector.addElement(cRISPR);
                }
            } else {
                vector.addElement(cRISPR);
            }
            bl = true;
            i = cRISPR.end() + 1;
        }
        try {
            if (bl) {
                ++this.totseqhit;
                this.out.print("SEQ: ");
                this.out.print(this.sequence.getName() + "\n");
                this.out.print("Bases: " + this.sequence.length() + "\n");
                this.out.print("Total CRISPR: " + vector.size() + "\n\n\n");
                System.out.println("Found " + vector.size() + " CRISPR in SEQ:" + this.sequence.getName() + " with " + this.sequence.length() + "bp\n");
                String string = "";
                String string2 = "";
                String string3 = "";
                for (int i = 0; i < vector.size(); ++i) {
                    object = (CRISPR)vector.elementAt(i);
                    this.out.print("CRISPR " + (i + 1) + "   Range: " + (((CRISPR)object).start() + 1) + " - " + (((CRISPR)object).end() + 1) + "\n");
                    this.out.print(((CRISPR)object).toString());
                    this.out.print("Repeats: " + ((CRISPR)object).numRepeats() + "\t" + "Average Length: " + ((CRISPR)object).getRepeatLength() + "\t\t");
                    this.out.print("Average Length: " + ((CRISPR)object).averageSpacerLength() + "\n\n");
                }
                this.out.print("\n");
            }
        }
        catch (Exception exception) {
            System.err.println("--Error writing to file-- \n");
        }
    }
}

