/*
 * Decompiled with CFR 0.152.
 */
public class DNASequence {
    public static String seq;
    private String name;
    private String errorLog = "";

    public DNASequence(String string) {
        seq = string.toUpperCase();
        this.name = "";
    }

    public DNASequence(String string, String string2) {
        seq = string.toUpperCase();
        this.name = string2;
    }

    public int length() {
        return seq.length();
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return seq;
    }

    public boolean isDNASequence() {
        int n = seq.length();
        if (n == 0) {
            this.errorLog = "Not a valid DNA sequence.  Sequence contains no characters.";
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (seq.charAt(i) == 'A' || seq.charAt(i) == 'T' || seq.charAt(i) == 'C' || seq.charAt(i) == 'G') {
                continue;
            }
            this.errorLog = "Not a valid DNA sequence.  Error found at position " + i + " scanning char " + seq.charAt(i);
            return false;
        }
        return true;
    }

    public String getErrorLog() {
        return this.errorLog;
    }

    public String substring(int n, int n2) {
        return seq.substring(n, n2);
    }

    public void toUpperCase() {
        seq = seq.toUpperCase();
    }

    public static int getHammingDistance(String string, String string2) {
        int n = string.length();
        int n2 = 0;
        if (string.length() != string2.length()) {
            n = DNASequence.min(string.length(), string2.length());
            n2 = Math.abs(string.length() - string2.length());
        }
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            ++n2;
        }
        return n2;
    }

    public static int getLevenshteinDistance1(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c2 = string2.charAt(n - 1);
                int n5 = c == c2 ? 0 : 1;
                nArray[n2][n] = DNASequence.Minimum(nArray[n2 - 1][n] + 1, nArray[n2][n - 1] + 1, nArray[n2 - 1][n - 1] + n5);
            }
        }
        return nArray[n3][n4];
    }

    public static int getLevenshteinDistance2(String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Strings must not be null");
        }
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        int[] nArray = new int[n2 + 1];
        int[] nArray2 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            nArray[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            nArray2[0] = i;
            for (n = 1; n <= n2; ++n) {
                int n4 = string.charAt(n - 1) == c ? 0 : 1;
                nArray2[n] = Math.min(Math.min(nArray2[n - 1] + 1, nArray[n] + 1), nArray[n - 1] + n4);
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n2];
    }

    public static double getSimilarity(String string, String string2) {
        int n = DNASequence.max(string.length(), string2.length());
        double d = 1.0 - (double)DNASequence.getLevenshteinDistance1(string, string2) / (double)n;
        return d;
    }

    private static boolean patternMatches(String string, String string2, double d) {
        double d2 = DNASequence.getSimilarity(string, string2);
        return d2 >= d;
    }

    private static int min(int[] nArray) {
        int n = nArray[0];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n) continue;
            n = nArray[i];
            n2 = i;
        }
        return n2;
    }

    private static int max(int[] nArray) {
        int n = nArray[0];
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
            n2 = i;
        }
        return n2;
    }

    private static int min(int n, int n2) {
        if (n < n2) {
            return n;
        }
        return n2;
    }

    private static int max(int n, int n2) {
        if (n < n2) {
            return n2;
        }
        return n;
    }

    private static int Minimum(int n, int n2, int n3) {
        int n4 = n;
        if (n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        return n4;
    }
}

