/* scan.h - codes and constants for scan program. */
#if !defined (SCAN)
#define SCAN
/*** #include <time.h> /****/
#include "afnio.h"
#include "histogram.h"
#include "probability.h"
#include "sequence.h"
#include "smatrix.h"
#include "smodel.h"
#include "mheap.h"
#include "sites.h"
#include "residues.h"

typedef struct {
	a_type  A;
	char	*snfile;
	Boolean	seqfile,repeats,shuffle,new_way;
	Boolean	neg_mask;
	long	min_segs, max_segs;
	long	N;			/** number of motif models **/
	long	hpsz;
	long	**pos;
	double	total;
	double	*freq;
	double	maxEval,logmaxEval;
	double	singlePval;	/** single Pval min **/
	sm_type  *M;
	mh_type H;
	h_type	HG;
	e_type	*E;
	char	method;		/** method used for model: g,c,r **/
} scan_type;
typedef scan_type *scn_typ;

#define MAX_BLOCK_SIZE  1000
#define MAX_BLOCK_LENGTH 200
#define MAX_NUM_MODELS	50
#define	ID_LENGTH	200

/********************************* PRIVATE ********************************/
long     foo_scan(long start, long m, long N, long **Items, long **scores, 
		long **site,long *path, long *w, long *tmp, long tmp_score, 
		long *best);

/********************************* PUBLIC ********************************/
scn_typ MkScan(double pseudo, char *snfile, long *counts, a_type A, 
	long hpsz, char method);
void    NilScan(scn_typ F);
long     MaskScan(FILE *fptr,long number, unsigned short *nsize, scn_typ F);
long     ScanScan(FILE *fptr,long number, unsigned short *nsize, scn_typ F);
long     ScanRScan(FILE *fptr,long number, unsigned short *nsize, scn_typ F);
long     OrderScanScan(FILE *fptr,long number, unsigned short *nsize, scn_typ F);
long	OrderScanMtf(char *name, scn_typ F);
long     PutScan(FILE *fptr, scn_typ F);
long     PutRScan(FILE *fptr, scn_typ F);
long     ReadScan(scn_typ F, double pseudo,char *snfile, long *counts);
long     SetMaxEvalScan(double maxEval, scn_typ F);

/********************************* MACROS ********************************/
#define OpenSeqFileScan(b,F)	((F)->seqfile = (b))
#define ShuffleSegsScan(F)	((F)->shuffle = TRUE)
#define SetMinSegsRScan(x,F)    ((F)->min_segs = (x))
#define SetMethodScan(x,F)	((F)->method = (char)(x))
#define SetMaxSegsRScan(x,F)    ((F)->max_segs = (x))
#define SetSinglePvalScan(x,F)  ((F)->singlePval = (double)(x))
#define UseNegMaskScan(F)	((F)->neg_mask = TRUE)
#define NumModelsScan(F)    	((F)->N)
#define SMatrixScan(m,F)	(((m) <= (F)->N && (m) > 0)?\
					GetSMatrixSModel((F)->M[(m)]): NULL)

#endif

