/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.Dictionary;
import com.orsonpdf.DictionaryObject;
import com.orsonpdf.GraphicsStream;
import com.orsonpdf.PDFFont;
import com.orsonpdf.PDFObject;
import com.orsonpdf.PDFUtils;
import com.orsonpdf.Page;
import com.orsonpdf.Pages;
import com.orsonpdf.util.Args;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PDFDocument {
    private static final Logger LOGGER = Logger.getLogger(PDFDocument.class.getName());
    private static final String PRODUCER = "OrsonPDF 1.6-eval";
    private static final boolean EVAL_VERSION = true;
    private DictionaryObject catalog = new DictionaryObject(this.nextNumber++, "/Catalog");
    private DictionaryObject outlines = new DictionaryObject(this.nextNumber++, "/Outlines");
    private DictionaryObject info = new DictionaryObject(this.nextNumber++, "/Info");
    private String title;
    private String author;
    private Pages pages;
    private List<PDFObject> otherObjects;
    private int nextNumber = 1;
    private GraphicsStream evaluationGraphicsStream;
    private boolean debug;

    public PDFDocument() {
        StringBuilder producer = new StringBuilder("(").append(PRODUCER);
        producer.append(" Evaluation Version");
        producer.append(")");
        this.info.put("Producer", producer.toString());
        Date now = new Date();
        String creationDateStr = "(" + PDFUtils.toDateFormat(now) + ")";
        this.info.put("CreationDate", creationDateStr);
        this.info.put("ModDate", creationDateStr);
        this.outlines.put("Count", 0);
        this.catalog.put("Outlines", this.outlines);
        this.pages = new Pages(this.nextNumber++, 0, this);
        this.catalog.put("Pages", this.pages);
        this.otherObjects = new ArrayList<PDFObject>();
    }

    final boolean isEvaluationVersion() {
        return true;
    }

    final GraphicsStream getEvaluationWatermark() {
        return this.evaluationGraphicsStream;
    }

    final void setEvaluationWatermark(GraphicsStream gs) {
        if (gs != null) {
            this.otherObjects.add(gs);
        }
        this.evaluationGraphicsStream = gs;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title != null) {
            this.info.put("Title", "(" + title + ")");
        } else {
            this.info.remove("Title");
        }
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
        if (author != null) {
            this.info.put("Author", "(" + this.author + ")");
        } else {
            this.info.remove("Author");
        }
    }

    public boolean isDebugMode() {
        return this.debug;
    }

    public void setDebugMode(boolean debug) {
        this.debug = debug;
    }

    public Page createPage(Rectangle2D bounds) {
        Page page = new Page(this.nextNumber++, 0, this.pages, bounds, !this.debug);
        this.pages.add(page);
        return page;
    }

    public void addObject(PDFObject object) {
        Args.nullNotPermitted(object, "object");
        this.otherObjects.add(object);
    }

    public int getNextNumber() {
        int result = this.nextNumber++;
        return result;
    }

    public byte[] getPDFBytes() {
        int[] xref = new int[this.nextNumber];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            bos.write(this.toBytes("%PDF-1.4\n"));
            bos.write(new byte[]{37, -128, -127, -126, -125, 10});
            xref[this.catalog.getNumber() - 1] = bos.size();
            bos.write(this.catalog.toPDFBytes());
            xref[this.outlines.getNumber() - 1] = bos.size();
            bos.write(this.outlines.toPDFBytes());
            xref[this.info.getNumber() - 1] = bos.size();
            bos.write(this.info.toPDFBytes());
            xref[this.pages.getNumber() - 1] = bos.size();
            bos.write(this.pages.toPDFBytes());
            for (Page page : this.pages.getPages()) {
                xref[page.getNumber() - 1] = bos.size();
                bos.write(page.toPDFBytes());
                PDFObject contents = page.getContents();
                xref[contents.getNumber() - 1] = bos.size();
                bos.write(contents.toPDFBytes());
            }
            for (PDFFont font : this.pages.getFonts()) {
                xref[font.getNumber() - 1] = bos.size();
                bos.write(font.toPDFBytes());
            }
            for (PDFObject object : this.otherObjects) {
                xref[object.getNumber() - 1] = bos.size();
                bos.write(object.toPDFBytes());
            }
            xref[xref.length - 1] = bos.size();
            bos.write(this.toBytes("xref\n"));
            bos.write(this.toBytes("0 " + String.valueOf(this.nextNumber) + "\n"));
            bos.write(this.toBytes("0000000000 65535 f \n"));
            for (int i = 0; i < this.nextNumber - 1; ++i) {
                String offset = String.valueOf(xref[i]);
                int len = offset.length();
                String offset10 = "0000000000".substring(len) + offset;
                bos.write(this.toBytes(offset10 + " 00000 n \n"));
            }
            bos.write(this.toBytes("trailer\n"));
            Dictionary trailer = new Dictionary();
            trailer.put("/Size", this.nextNumber);
            trailer.put("/Root", this.catalog);
            trailer.put("/Info", this.info);
            bos.write(trailer.toPDFBytes());
            bos.write(this.toBytes("startxref\n"));
            bos.write(this.toBytes(String.valueOf(xref[this.nextNumber - 1]) + "\n"));
            bos.write(this.toBytes("%%EOF"));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File f) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(this.getPDFBytes());
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, null, ex);
            }
        }
    }

    private byte[] toBytes(String s) {
        byte[] result = null;
        try {
            result = s.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }
}

