/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

public class PlatformInfo {
    public static final int MACINTOSH = 0;
    public static final int WINDOWS = 1;
    public static final int UNIX = 2;
    private static final int WIN_UNKNOWN = 0;
    private static final int WIN_NT = 1;
    private static final int WIN_2000 = 2;
    private static final int WIN_XP = 3;
    private static final int WIN_VISTA = 4;
    private static final int LINUX = 5;
    private static final int SOLARIS = 6;
    private static final int LINUX_64 = 7;
    private static final int POWERPC = 0;
    private static final int INTEL = 1;
    private static int sPlatform = -1;
    private static int sOSVersion = -1;
    private static int sMacArch = -1;
    private static boolean sIs64Bit;

    private static int determinePlatform() {
        int n;
        String string = System.getProperty("sun.arch.data.model");
        sIs64Bit = string != null && string.equals("64");
        String string2 = System.getProperty("os.name");
        if (string2.startsWith("Mac OS")) {
            n = 0;
            String string3 = System.getProperty("os.arch");
            if ("ppc".equals(string3)) {
                sMacArch = 0;
            } else if ("i386".equals(string3)) {
                sMacArch = 1;
            }
        } else if (string2.startsWith("Windows")) {
            n = 1;
            if (string2.indexOf("NT") != -1) {
                sOSVersion = 1;
                String string4 = System.getProperty("os.version");
                if (string4 != null && string4.length() > 0 && string4.charAt(0) == '6') {
                    sOSVersion = 4;
                }
            } else if (string2.indexOf("2000") != -1) {
                sOSVersion = 2;
                String string5 = System.getProperty("os.version");
                if (string5 != null && string5.length() > 2) {
                    char c = string5.charAt(0);
                    char c2 = string5.charAt(2);
                    if (Character.isDigit(c) && Character.isDigit(c2)) {
                        int n2 = Character.getNumericValue(c);
                        int n3 = Character.getNumericValue(c2);
                        if (n2 == 5 && n3 > 0 || n2 > 5) {
                            sOSVersion = 3;
                        }
                    }
                }
            } else {
                sOSVersion = string2.indexOf("2003") != -1 ? 3 : (string2.indexOf("XP") != -1 ? 3 : (string2.indexOf("Vista") != -1 ? 4 : 0));
            }
        } else {
            n = 2;
            if (string2.indexOf("Linux") != -1) {
                String string6 = System.getProperty("os.arch");
                sOSVersion = string6 != null && string6.indexOf("64") != -1 ? 7 : 5;
            } else if (string2.indexOf("SunOS") != -1) {
                sOSVersion = 6;
            }
        }
        return n;
    }

    public static boolean isMacintosh() {
        return sPlatform == 0;
    }

    public static boolean isMac64() {
        return PlatformInfo.isMacintosh() && sIs64Bit;
    }

    public static boolean isUnix() {
        return sPlatform == 2 || sPlatform == 0;
    }

    public static boolean isWindows() {
        return sPlatform == 1;
    }

    public static boolean isWindowsXP() {
        return sOSVersion == 3;
    }

    public static boolean isWindowsVista() {
        return sOSVersion == 4;
    }

    public static boolean isWindows64() {
        return PlatformInfo.isWindows() && sIs64Bit;
    }

    public static boolean isLinux() {
        return sOSVersion == 5 || sOSVersion == 7;
    }

    public static boolean isLinux64() {
        return sOSVersion == 7;
    }

    public static boolean isSolaris() {
        return sOSVersion == 6;
    }

    public static boolean isSolaris64() {
        return PlatformInfo.isSolaris() && sIs64Bit;
    }

    public static String getArch() {
        if (PlatformInfo.isLinux()) {
            return PlatformInfo.isLinux64() ? "glnxa64" : "glnx86";
        }
        if (PlatformInfo.isWindows()) {
            return PlatformInfo.isWindows64() ? "win64" : "win32";
        }
        if (PlatformInfo.isMacintosh()) {
            return PlatformInfo.isMac64() ? "maci64" : "maci";
        }
        if (PlatformInfo.isSolaris()) {
            return PlatformInfo.isSolaris64() ? "sol64" : "sol2";
        }
        return "UNKNOWN";
    }

    static {
        sPlatform = PlatformInfo.determinePlatform();
    }
}

