/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.graphics2d.canvas;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Map;
import org.jfree.graphics2d.Args;
import org.jfree.graphics2d.GraphicsUtils;

public final class CanvasGraphics2D
extends Graphics2D {
    private String canvasID;
    private StringBuilder sb;
    private RenderingHints hints;
    private Shape clip;
    private Paint paint = Color.BLACK;
    private Color color = Color.BLACK;
    private Composite composite = AlphaComposite.getInstance(3, 1.0f);
    private Stroke stroke = new BasicStroke(1.0f);
    private Font font = new Font("SansSerif", 0, 12);
    private AffineTransform transform = new AffineTransform();
    private Color background = Color.BLACK;
    private BufferedImage image = new BufferedImage(10, 10, 1);
    private Line2D line;
    Rectangle2D rect;
    private RoundRectangle2D roundRect;
    private Ellipse2D oval;
    private Arc2D arc;
    private int transformDP;
    private DecimalFormat transformFormat;
    private int geometryDP;
    private DecimalFormat geometryFormat = new DecimalFormat("0.##");

    public CanvasGraphics2D(String canvasID) {
        this.canvasID = canvasID;
        this.sb = new StringBuilder();
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.clip = null;
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.transformFormat = new DecimalFormat("0.######", dfs);
        this.geometryFormat = new DecimalFormat("0.##", dfs);
    }

    public String getCanvasID() {
        return this.canvasID;
    }

    public int getTransformDP() {
        return this.transformDP;
    }

    public void setTransformDP(int dp) {
        this.transformDP = dp;
        if (dp < 1 || dp > 10) {
            this.transformFormat = null;
            return;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.transformFormat = new DecimalFormat("0." + "##########".substring(0, dp), dfs);
    }

    public int getGeometryDP() {
        return this.geometryDP;
    }

    public void setGeometryDP(int dp) {
        this.geometryDP = dp;
        if (dp < 1 || dp > 10) {
            this.geometryFormat = null;
            return;
        }
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        this.geometryFormat = new DecimalFormat("0." + "##########".substring(0, dp), dfs);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Graphics create() {
        CanvasGraphics2D copy = new CanvasGraphics2D(this.canvasID);
        copy.setRenderingHints(this.getRenderingHints());
        copy.setClip(this.getClip());
        copy.setPaint(this.getPaint());
        copy.setColor(this.getColor());
        copy.setComposite(this.getComposite());
        copy.setStroke(this.getStroke());
        copy.setFont(this.getFont());
        copy.setTransform(this.getTransform());
        copy.setBackground(this.getBackground());
        return copy;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.setColor((Color)paint);
        } else if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            this.sb.append("var g = ctx.createLinearGradient(").append(this.geomDP(p1.getX())).append(",").append(this.geomDP(p1.getY())).append(",").append(this.geomDP(p2.getX())).append(",").append(this.geomDP(p2.getY())).append(");");
            this.sb.append("g.addColorStop(0,'").append(this.toCSSColorValue(gp.getColor1())).append("');");
            this.sb.append("g.addColorStop(1,'").append(this.toCSSColorValue(gp.getColor2())).append("');");
            this.sb.append("ctx.fillStyle=g;");
        } else {
            System.err.println("setPaint(" + paint + ")");
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        if (c == null || this.color.equals(c)) {
            return;
        }
        this.color = c;
        this.paint = c;
        String cssColor = this.toCSSColorValue(c);
        this.sb.append("ctx.fillStyle=\"").append(cssColor).append("\";");
        this.sb.append("ctx.strokeStyle=\"").append(cssColor).append("\";");
    }

    private String toCSSColorValue(Color c) {
        return "rgba(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + "," + (float)c.getAlpha() / 255.0f + ")";
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(Color color) {
        this.background = color;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public void setComposite(Composite comp) {
        Args.nullNotPermitted(comp, "comp");
        this.composite = comp;
        if (comp instanceof AlphaComposite) {
            AlphaComposite ac = (AlphaComposite)comp;
            this.sb.append("ctx.globalAlpha=").append(ac.getAlpha()).append(";");
            this.sb.append("ctx.globalCompositeOperation=\"").append(this.toJSCompositeRuleName(ac.getRule())).append("\";");
        }
    }

    private String toJSCompositeRuleName(int rule) {
        switch (rule) {
            case 1: {
                return "xor";
            }
            case 5: {
                return "source-in";
            }
            case 7: {
                return "source-out";
            }
            case 3: {
                return "source-over";
            }
            case 10: {
                return "source-atop";
            }
            case 6: {
                return "destination-in";
            }
            case 8: {
                return "destination-out";
            }
            case 4: {
                return "destination-over";
            }
            case 11: {
                return "destination-atop";
            }
        }
        throw new IllegalArgumentException("Unknown/unhandled 'rule' " + rule);
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        Args.nullNotPermitted(s, "s");
        this.stroke = s;
        if (s instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)s;
            this.sb.append("ctx.lineWidth=").append(bs.getLineWidth()).append(";");
            if (bs.getDashArray() != null) {
                this.sb.append("ctx.setLineDash([");
                for (int i = 0; i < bs.getDashArray().length; ++i) {
                    if (i != 0) {
                        this.sb.append(",");
                    }
                    this.sb.append((int)bs.getDashArray()[i]);
                }
                this.sb.append("]);");
            } else {
                this.sb.append("ctx.setLineDash([]);");
            }
        }
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.hints.clone();
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.hints.putAll(hints);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public void draw(Shape s) {
        if (s instanceof Line2D || s instanceof Rectangle2D || s instanceof Path2D) {
            this.shapeToPath(s);
            this.sb.append("ctx.stroke();");
        } else {
            this.draw(new GeneralPath(s));
        }
    }

    @Override
    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            if (r.isEmpty()) {
                return;
            }
            this.sb.append("ctx.fillRect(").append(this.geomDP(r.getX())).append(",").append(this.geomDP(r.getY())).append(",").append(this.geomDP(r.getWidth())).append(",").append(this.geomDP(r.getHeight())).append(");");
        } else if (s instanceof Path2D) {
            this.shapeToPath(s);
            this.sb.append("ctx.fill();");
        } else {
            this.fill(new GeneralPath(s));
        }
    }

    private void shapeToPath(Shape s) {
        if (s instanceof Line2D) {
            Line2D l = (Line2D)s;
            this.sb.append("ctx.beginPath();");
            this.sb.append("ctx.moveTo(").append(this.geomDP(l.getX1())).append(",").append(this.geomDP(l.getY1())).append(");");
            this.sb.append("ctx.lineTo(").append(this.geomDP(l.getX2())).append(",").append(this.geomDP(l.getY2())).append(");");
            this.sb.append("ctx.closePath();");
        } else if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.sb.append("ctx.beginPath();");
            this.sb.append("ctx.rect(").append(this.geomDP(r.getX())).append(",").append(this.geomDP(r.getY())).append(",").append(this.geomDP(r.getWidth())).append(",").append(this.geomDP(r.getHeight())).append(");");
            this.sb.append("ctx.closePath();");
        } else if (s instanceof Path2D) {
            Path2D p = (Path2D)s;
            float[] coords = new float[6];
            double[] closePt = null;
            PathIterator iterator = p.getPathIterator(this.getTransform());
            this.sb.append("ctx.beginPath();");
            while (!iterator.isDone()) {
                int type = iterator.currentSegment(coords);
                switch (type) {
                    case 0: {
                        closePt = new double[]{coords[0], coords[1]};
                        this.sb.append("ctx.moveTo(").append(this.geomDP(coords[0])).append(",").append(this.geomDP(coords[1])).append(");");
                        break;
                    }
                    case 1: {
                        this.sb.append("ctx.lineTo(").append(this.geomDP(coords[0])).append(",").append(this.geomDP(coords[1])).append(");");
                        break;
                    }
                    case 2: {
                        this.sb.append("ctx.quadraticCurveTo(").append(this.geomDP(coords[0])).append(",").append(this.geomDP(coords[1])).append(",").append(this.geomDP(coords[2])).append(",").append(this.geomDP(coords[3])).append(");");
                        break;
                    }
                    case 3: {
                        this.sb.append("ctx.bezierCurveTo(").append(this.geomDP(coords[0])).append(",").append(this.geomDP(coords[1])).append(",").append(this.geomDP(coords[2])).append(",").append(this.geomDP(coords[3])).append(",").append(this.geomDP(coords[4])).append(",").append(this.geomDP(coords[5])).append(");");
                        break;
                    }
                    case 4: {
                        if (closePt == null) break;
                        this.sb.append("ctx.lineTo(").append(this.geomDP(closePt[0])).append(",").append(this.geomDP(closePt[1])).append(");");
                        break;
                    }
                }
                iterator.next();
            }
        } else {
            throw new RuntimeException("Unhandled shape " + s);
        }
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        if (font == null || this.font.equals(font)) {
            return;
        }
        this.font = font;
        this.sb.append("ctx.font=\"").append(font.getSize()).append("px ").append(font.getFontName()).append("\";");
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.image.createGraphics().getFontMetrics(f);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.image.createGraphics().getFontRenderContext();
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, float x, float y) {
        if (str == null) {
            throw new NullPointerException("Null 'str' argument.");
        }
        this.sb.append("ctx.save();");
        if (this.paint instanceof Color) {
            this.sb.append("ctx.fillStyle=\"").append(this.toCSSColorValue((Color)this.paint)).append("\";");
        } else {
            this.setPaint(this.paint);
        }
        this.sb.append("ctx.fillText(\"").append(str).append("\",").append(this.geomDP(x)).append(",").append(this.geomDP(y)).append(");");
        this.sb.append("ctx.restore();");
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        TextLayout layout = new TextLayout(iterator, this.getFontRenderContext());
        layout.draw(this, x, y);
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.fill(g.getOutline(x, y));
    }

    @Override
    public void translate(int tx, int ty) {
        this.translate((double)tx, (double)ty);
    }

    @Override
    public void translate(double tx, double ty) {
        AffineTransform t = this.getTransform();
        t.translate(tx, ty);
        this.setTransform(t);
    }

    @Override
    public void rotate(double theta) {
        AffineTransform t = AffineTransform.getRotateInstance(theta);
        this.transform(t);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.translate(x, y);
        this.rotate(theta);
        this.translate(-x, -y);
    }

    @Override
    public void scale(double sx, double sy) {
        AffineTransform t = this.getTransform();
        t.scale(sx, sy);
        this.setTransform(t);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform(AffineTransform.getShearInstance(shx, shy));
    }

    @Override
    public void transform(AffineTransform t) {
        this.sb.append("ctx.transform(");
        this.sb.append(this.transformDP(t.getScaleX())).append(",");
        this.sb.append(this.transformDP(t.getShearY())).append(",");
        this.sb.append(this.transformDP(t.getShearX())).append(",");
        this.sb.append(this.transformDP(t.getScaleY())).append(",");
        this.sb.append(this.transformDP(t.getTranslateX())).append(",");
        this.sb.append(this.transformDP(t.getTranslateY()));
        this.sb.append(");");
        AffineTransform tx = this.getTransform();
        tx.concatenate(t);
        this.setTransform(tx);
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public void setTransform(AffineTransform t) {
        this.transform = t == null ? new AffineTransform() : new AffineTransform(t);
        this.sb.append("ctx.setTransform(");
        this.sb.append(this.transformDP(this.transform.getScaleX())).append(",");
        this.sb.append(this.transformDP(this.transform.getShearY())).append(",");
        this.sb.append(this.transformDP(this.transform.getShearX())).append(",");
        this.sb.append(this.transformDP(this.transform.getScaleY())).append(",");
        this.sb.append(this.transformDP(this.transform.getTranslateX())).append(",");
        this.sb.append(this.transformDP(this.transform.getTranslateY()));
        this.sb.append(");");
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        Shape ts = onStroke ? this.transform.createTransformedShape(this.stroke.createStrokedShape(s)) : this.transform.createTransformedShape(s);
        if (!rect.getBounds2D().intersects(ts.getBounds2D())) {
            return false;
        }
        Area a1 = new Area(rect);
        Area a2 = new Area(ts);
        a1.intersect(a2);
        return !a1.isEmpty();
    }

    @Override
    public void setPaintMode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setXORMode(Color c1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.getClip().getBounds();
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        try {
            AffineTransform inv = this.transform.createInverse();
            return inv.createTransformedShape(this.clip);
        }
        catch (NoninvertibleTransformException ex) {
            return null;
        }
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = this.transform.createTransformedShape(shape);
    }

    @Override
    public void clip(Shape s) {
        if (this.clip == null) {
            this.setClip(s);
            return;
        }
        Shape ts = this.transform.createTransformedShape(s);
        if (!ts.intersects(this.clip.getBounds2D())) {
            this.setClip(new Rectangle2D.Double());
        } else {
            Area a1 = new Area(ts);
            Area a2 = new Area(this.clip);
            a1.intersect(a2);
            this.clip = new Path2D.Double(a1);
        }
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.clip(this.rect);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.setClip(this.rect);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.line == null) {
            this.line = new Line2D.Double(x1, y1, x2, y2);
        } else {
            this.line.setLine(x1, y1, x2, y2);
        }
        this.draw(this.line);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.setRect(x, y, width, height);
        this.fill(this.rect);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        if (this.getBackground() == null) {
            return;
        }
        Paint saved = this.getPaint();
        this.setPaint(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setPaint(saved);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.draw(this.roundRect);
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        this.fill(this.roundRect);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.draw(this.oval);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.setOval(x, y, width, height);
        this.fill(this.oval);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.draw(this.arc);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.setArc(x, y, width, height, startAngle, arcAngle);
        this.fill(this.arc);
    }

    @Override
    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, false);
        this.draw(p);
    }

    @Override
    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.draw(p);
    }

    @Override
    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath p = GraphicsUtils.createPolygon(xPoints, yPoints, nPoints, true);
        this.fill(p);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform savedTransform = this.getTransform();
        this.transform(xform);
        boolean result = this.drawImage(img, 0, 0, obs);
        this.setTransform(savedTransform);
        return result;
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        BufferedImage imageToDraw = op.filter(img, null);
        this.drawImage(imageToDraw, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), null);
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        BufferedImage bi = GraphicsUtils.convertRenderedImage(img);
        this.drawImage(bi, xform, null);
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        RenderedImage ri = img.createDefaultRendering();
        this.drawRenderedImage(ri, xform);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        int w = img.getWidth(null);
        if (w < 0) {
            return false;
        }
        int h = img.getHeight(null);
        if (h < 0) {
            return false;
        }
        return this.drawImage(img, x, y, w, h, bgcolor, observer);
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int w, int h, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(x, y, w, h);
        this.setPaint(saved);
        return this.drawImage(img, x, y, w, h, observer);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        int w = dx2 - dx1;
        int h = dy2 - dy1;
        BufferedImage img2 = new BufferedImage(2, w, h);
        Graphics2D g2 = img2.createGraphics();
        g2.drawImage(img, 0, 0, w, h, sx1, sy1, sx2, sy2, null);
        return this.drawImage((Image)img2, dx1, dx2, null);
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Paint saved = this.getPaint();
        this.setPaint(bgcolor);
        this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
        this.setPaint(saved);
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
    }

    @Override
    public void dispose() {
    }

    public String getScript() {
        return this.sb.toString();
    }

    private String transformDP(double d) {
        if (this.transformFormat != null) {
            return this.transformFormat.format(d);
        }
        return String.valueOf(d);
    }

    private String geomDP(double d) {
        if (this.geometryFormat != null) {
            return this.geometryFormat.format(d);
        }
        return String.valueOf(d);
    }

    private void setRect(int x, int y, int width, int height) {
        if (this.rect == null) {
            this.rect = new Rectangle2D.Double(x, y, width, height);
        } else {
            this.rect.setRect(x, y, width, height);
        }
    }

    private void setRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.roundRect == null) {
            this.roundRect = new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight);
        } else {
            this.roundRect.setRoundRect(x, y, width, height, arcWidth, arcHeight);
        }
    }

    private void setArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.arc == null) {
            this.arc = new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0);
        } else {
            this.arc.setArc(x, y, width, height, startAngle, arcAngle, 0);
        }
    }

    private void setOval(int x, int y, int width, int height) {
        if (this.oval == null) {
            this.oval = new Ellipse2D.Double(x, y, width, height);
        } else {
            this.oval.setFrame(x, y, width, height);
        }
    }
}

