/*
 * Decompiled with CFR 0.152.
 */
package audiosteganography;

import audiosteganography.ASCII;
import audiosteganography.audio.AudioSampleReader;
import audiosteganography.audio.AudioSampleWriter;
import audiosteganography.fourier.Complex;
import audiosteganography.fourier.FFT;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Encoder {
    File audioFile;

    public Encoder(File audioFile) {
        this.audioFile = audioFile;
    }

    public void encodeMessage(String message, String outPath) {
        ASCII phrase = new ASCII(message);
        int[] messageAsBits = phrase.getBinaryBitArray();
        int currentBit = 0;
        try {
            AudioSampleReader sampleReader = new AudioSampleReader(this.audioFile);
            int bytesRead = 0;
            int nbChannels = sampleReader.getFormat().getChannels();
            int totalBytes = (int)sampleReader.getSampleCount() * nbChannels;
            double[] out = new double[totalBytes];
            int bytesToRead = 8192;
            double[] audioData = new double[totalBytes];
            sampleReader.getInterleavedSamples(0L, totalBytes, audioData);
            if (totalBytes / bytesToRead < messageAsBits.length) {
                throw new RuntimeException("The audio file is too short for the message to fit!");
            }
            while (bytesRead < totalBytes && currentBit < messageAsBits.length) {
                if (totalBytes - bytesRead < bytesToRead) {
                    bytesToRead = totalBytes - bytesRead;
                }
                double[] samples = new double[bytesToRead];
                for (int i = 0; i < samples.length; ++i) {
                    samples[i] = audioData[bytesRead + i];
                }
                bytesRead += bytesToRead;
                double[] channelOne = new double[samples.length / 2];
                sampleReader.getChannelSamples(0, samples, channelOne);
                FFT fft = new FFT();
                double[][] freqMag = FFT.getMag(channelOne, (int)sampleReader.getFormat().getFrameRate());
                channelOne = FFT.correctDataLength(channelOne);
                Complex[] complexData = new Complex[channelOne.length];
                for (int i = 0; i < channelOne.length; ++i) {
                    complexData[i] = new Complex(channelOne[i], 0.0);
                }
                Complex[] complexMags = FFT.fft(complexData);
                double[] freqs = FFT.getFreqs(complexData.length, (int)sampleReader.getFormat().getFrameRate());
                double fundamentalAmp = 0.0;
                for (int i = 0; i < freqMag.length; ++i) {
                    if (!(Math.abs(freqMag[i][1]) > fundamentalAmp)) continue;
                    fundamentalAmp = freqMag[i][1];
                }
                boolean isRest = false;
                if (fundamentalAmp < 0.01) {
                    isRest = true;
                }
                if (messageAsBits[currentBit] == 1 && !isRest) {
                    for (int i = 0; i < freqs.length; ++i) {
                        if (!(Math.abs(Math.abs(freqs[i]) - 20000.0) < 5.0)) continue;
                        complexMags[i] = new Complex(0.01 * (double)channelOne.length, 0.0);
                    }
                    Complex[] ifft = FFT.ifft(complexMags);
                    double[] ifftReal = new double[ifft.length];
                    for (int i = 0; i < ifftReal.length; ++i) {
                        ifftReal[i] = ifft[i].re();
                    }
                    Encoder.appendOutput(Encoder.interleaveSamples(ifftReal), bytesRead - bytesToRead, out);
                    ++currentBit;
                    continue;
                }
                if (messageAsBits[currentBit] == 0 && !isRest) {
                    Encoder.appendOutput(samples, bytesRead - bytesToRead, out);
                    ++currentBit;
                    continue;
                }
                if (!isRest) continue;
                Encoder.appendOutput(samples, bytesRead - bytesToRead, out);
            }
            if (bytesRead < totalBytes) {
                double[] leftoverData = new double[totalBytes - bytesRead];
                for (int i = 0; i < leftoverData.length; ++i) {
                    leftoverData[i] = audioData[bytesRead + i];
                }
                Encoder.appendOutput(leftoverData, bytesRead, out);
            }
            File outFile = new File(outPath);
            AudioSampleWriter audioWriter = new AudioSampleWriter(outFile, sampleReader.getFormat(), AudioFileFormat.Type.WAVE);
            audioWriter.write(out);
            audioWriter.close();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static double[] interleaveSamples(double[] mono) {
        double[] interleavedSamples = new double[mono.length * 2];
        int interleavedSamplesCounter = 0;
        for (int i = 0; i < mono.length; ++i) {
            interleavedSamples[interleavedSamplesCounter] = mono[i];
            interleavedSamples[++interleavedSamplesCounter] = mono[i];
            ++interleavedSamplesCounter;
        }
        return interleavedSamples;
    }

    private static void appendOutput(double[] in, int startIndex, double[] out) {
        for (int i = 0; i < in.length; ++i) {
            out[startIndex] = in[i];
            ++startIndex;
        }
    }

    public static void main(String[] args) {
        String message = args[0];
        String filePath = args[1];
        String outPath = filePath.substring(0, filePath.length() - 4) + "-Encoded.wav";
        Encoder encoder = new Encoder(new File(filePath));
        encoder.encodeMessage(message, outPath);
        System.out.println("Successfully encoded the message into " + outPath);
    }
}

