/*
 * Decompiled with CFR 0.152.
 */
package audiosteganography.fourier;

import audiosteganography.fourier.Complex;

public class FFT {
    public static Complex[] fft(Complex[] x) {
        int N = x.length;
        if (N == 1) {
            return new Complex[]{x[0]};
        }
        if (N % 2 != 0) {
            throw new RuntimeException("N is not a power of 2");
        }
        Complex[] even = new Complex[N / 2];
        for (int k = 0; k < N / 2; ++k) {
            even[k] = x[2 * k];
        }
        Complex[] q = FFT.fft(even);
        Complex[] odd = even;
        for (int k = 0; k < N / 2; ++k) {
            odd[k] = x[2 * k + 1];
        }
        Complex[] r = FFT.fft(odd);
        Complex[] y = new Complex[N];
        for (int k = 0; k < N / 2; ++k) {
            double kth = (double)(-2 * k) * Math.PI / (double)N;
            Complex wk = new Complex(Math.cos(kth), Math.sin(kth));
            y[k] = q[k].plus(wk.times(r[k]));
            y[k + N / 2] = q[k].minus(wk.times(r[k]));
        }
        return y;
    }

    public static Complex[] ifft(Complex[] x) {
        int i;
        int N = x.length;
        Complex[] y = new Complex[N];
        for (i = 0; i < N; ++i) {
            y[i] = x[i].conjugate();
        }
        y = FFT.fft(y);
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conjugate();
        }
        for (i = 0; i < N; ++i) {
            y[i] = y[i].conjugate();
            y[i] = y[i].times(1.0 / (double)N);
        }
        return y;
    }

    public static double[][] getMag(double[] data, int Fs) {
        data = FFT.correctDataLength(data);
        Complex[] x = new Complex[data.length];
        for (int i = 0; i < data.length; ++i) {
            x[i] = new Complex(data[i], 0.0);
        }
        Complex[] y = FFT.fft(x);
        int n = y.length;
        double[] k = new double[n];
        int j = 0;
        for (int i = -n / 2; i < n / 2 - 1; ++i) {
            k[j] = i;
            ++j;
        }
        double T = (double)n / (double)Fs;
        double[] amp = new double[n];
        for (int i = 0; i < n; ++i) {
            amp[i] = y[i].divides(new Complex(n, 0.0)).abs();
        }
        FFT.fftShift(amp);
        double[][] freqMag = new double[n][2];
        for (int i = 0; i < n; ++i) {
            freqMag[i][0] = k[i] / T;
            freqMag[i][1] = amp[i];
        }
        return freqMag;
    }

    public static void fftShift(double[] x) {
        int i;
        double[] temp = new double[x.length];
        for (i = 0; i < x.length; ++i) {
            temp[i] = x[i];
        }
        for (i = 0; i < x.length / 2; ++i) {
            x[i] = temp[x.length / 2 + i];
            x[x.length / 2 + i] = temp[i];
        }
    }

    public static double[] correctDataLength(double[] in) {
        int n = in.length;
        double x = (int)(Math.log(n) / Math.log(2.0));
        if (Math.abs(x - Math.log(n) / Math.log(2.0)) < 1.0E-6) {
            return in;
        }
        int newLength = (int)Math.pow(2.0, x);
        double[] correctArray = new double[newLength];
        for (int i = 0; i < newLength - 1; ++i) {
            correctArray[i] = i < in.length ? in[i] : 0.0;
        }
        return correctArray;
    }

    public static double[] getFreqs(int n, int fS) {
        double[] freqs = new double[n];
        double[] k = new double[n];
        int j = 0;
        for (int i = -n / 2; i < n / 2 - 1; ++i) {
            k[j] = i;
            ++j;
        }
        double T = (double)n / (double)fS;
        for (int i = 0; i < freqs.length; ++i) {
            freqs[i] = k[i] / T;
        }
        FFT.fftShift(freqs);
        return freqs;
    }
}

