/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d;

import com.orsoncharts.graphics3d.Point3D;

public class Utils3D {
    private Utils3D() {
    }

    public static double length(Point3D v) {
        return Math.sqrt(v.x * v.x + v.y * v.y + v.z * v.z);
    }

    public static Point3D normalise(Point3D v) {
        double length = Utils3D.length(v);
        return new Point3D(v.x / length, v.y / length, v.z / length);
    }

    public static double scalarprod(Point3D a, Point3D b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }

    public static Point3D normal(Point3D a, Point3D b, Point3D c) {
        double ax = a.x - c.x;
        double ay = a.y - c.y;
        double az = a.z - c.z;
        double bx = b.x - c.x;
        double by = b.y - c.y;
        double bz = b.z - c.z;
        return new Point3D(ay * bz - az * by, az * bx - ax * bz, ax * by - ay * bx);
    }

    public static double angle(Point3D a, Point3D b) {
        double dp = a.x * b.x + a.y * b.y + a.z * b.z;
        double alen = Utils3D.length(a);
        double blen = Utils3D.length(b);
        double c = dp / (alen * blen);
        c = Math.max(-1.0, Math.min(1.0, c));
        return Math.acos(c);
    }
}

