/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.graphics3d.swing;

import com.orsoncharts.Resources;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.util.ArgChecks;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ExportToJPEGAction
extends AbstractAction {
    private Panel3D panel;

    public ExportToJPEGAction(Panel3D panel) {
        super(Resources.localString("JPG_MENU_LABEL"));
        ArgChecks.nullNotPermitted(panel, "panel");
        this.panel = panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        FileNameExtensionFilter filter = new FileNameExtensionFilter(Resources.localString("JPG_FILE_FILTER_DESCRIPTION"), "jpg");
        fileChooser.addChoosableFileFilter(filter);
        fileChooser.setFileFilter(filter);
        int option = fileChooser.showSaveDialog(this.panel);
        if (option == 0) {
            String filename = fileChooser.getSelectedFile().getPath();
            if (!filename.endsWith(".jpg")) {
                filename = filename + ".jpg";
            }
            Dimension size = this.panel.getSize();
            int w = (int)((Dimension2D)size).getWidth();
            int h = (int)((Dimension2D)size).getHeight();
            BufferedImage image = new BufferedImage(w, h, 1);
            Graphics2D g2 = image.createGraphics();
            this.panel.getDrawable().draw(g2, new Rectangle(w, h));
            try {
                ImageIO.write((RenderedImage)image, "jpeg", new File(filename));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

