/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.plot;

import com.orsoncharts.ChartElementVisitor;
import com.orsoncharts.data.DataUtils;
import com.orsoncharts.data.ItemKey;
import com.orsoncharts.data.KeyedValuesItemKey;
import com.orsoncharts.data.PieDataset3D;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.Dot3D;
import com.orsoncharts.graphics3d.Object3D;
import com.orsoncharts.graphics3d.World;
import com.orsoncharts.label.PieLabelGenerator;
import com.orsoncharts.label.StandardPieLabelGenerator;
import com.orsoncharts.legend.LegendItemInfo;
import com.orsoncharts.legend.StandardLegendItemInfo;
import com.orsoncharts.plot.AbstractPlot3D;
import com.orsoncharts.plot.ColorSource;
import com.orsoncharts.plot.FontSource;
import com.orsoncharts.plot.StandardColorSource;
import com.orsoncharts.plot.StandardFontSource;
import com.orsoncharts.util.ArgChecks;
import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PiePlot3D
extends AbstractPlot3D
implements Serializable {
    public static final Font DEFAULT_SECTION_LABEL_FONT = new Font("Dialog", 0, 14);
    private PieDataset3D dataset;
    private double radius;
    private double depth;
    private ColorSource sectionColorSource;
    private PieLabelGenerator sectionLabelGenerator;
    private FontSource sectionLabelFontSource;
    private ColorSource sectionLabelColorSource;
    private PieLabelGenerator legendLabelGenerator;
    private PieLabelGenerator toolTipGenerator;
    private int segments = 40;

    public PiePlot3D(PieDataset3D dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.radius = 4.0;
        this.depth = 0.5;
        this.sectionColorSource = new StandardColorSource();
        this.sectionLabelGenerator = new StandardPieLabelGenerator("%s");
        this.sectionLabelFontSource = new StandardFontSource(DEFAULT_SECTION_LABEL_FONT);
        this.sectionLabelColorSource = new StandardColorSource(Color.BLACK);
        this.legendLabelGenerator = new StandardPieLabelGenerator();
        this.toolTipGenerator = new StandardPieLabelGenerator("%s (%3$,.2f%%)");
    }

    public PieDataset3D getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset3D dataset) {
        ArgChecks.nullNotPermitted(dataset, "dataset");
        this.dataset.removeChangeListener(this);
        this.dataset = dataset;
        this.dataset.addChangeListener(this);
        this.fireChangeEvent(true);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.fireChangeEvent(true);
    }

    public double getDepth() {
        return this.depth;
    }

    public void setDepth(double depth) {
        this.depth = depth;
        this.fireChangeEvent(true);
    }

    public ColorSource getSectionColorSource() {
        return this.sectionColorSource;
    }

    public void setSectionColorSource(ColorSource source) {
        ArgChecks.nullNotPermitted(source, "source");
        this.sectionColorSource = source;
        this.fireChangeEvent(true);
    }

    public void setSectionColors(Color ... colors) {
        this.setSectionColorSource(new StandardColorSource(colors));
    }

    public PieLabelGenerator getSectionLabelGenerator() {
        return this.sectionLabelGenerator;
    }

    public void setSectionLabelGenerator(PieLabelGenerator generator) {
        ArgChecks.nullNotPermitted(generator, "generator");
        this.sectionLabelGenerator = generator;
        this.fireChangeEvent(false);
    }

    public FontSource getSectionLabelFontSource() {
        return this.sectionLabelFontSource;
    }

    public void setSectionLabelFontSource(FontSource source) {
        ArgChecks.nullNotPermitted(source, "source");
        this.sectionLabelFontSource = source;
        this.fireChangeEvent(false);
    }

    public ColorSource getSectionLabelColorSource() {
        return this.sectionLabelColorSource;
    }

    public void setSectionLabelColorSource(ColorSource source) {
        ArgChecks.nullNotPermitted(source, "source");
        this.sectionLabelColorSource = source;
        this.fireChangeEvent(false);
    }

    public PieLabelGenerator getLegendLabelGenerator() {
        return this.legendLabelGenerator;
    }

    public void setLegendLabelGenerator(PieLabelGenerator generator) {
        ArgChecks.nullNotPermitted(generator, "generator");
        this.legendLabelGenerator = generator;
        this.fireChangeEvent(false);
    }

    public PieLabelGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(PieLabelGenerator generator) {
        this.toolTipGenerator = generator;
        this.fireChangeEvent(false);
    }

    @Override
    public Dimension3D getDimensions() {
        return new Dimension3D(this.radius * 2.0, this.depth, this.radius * 2.0);
    }

    public int getSegmentCount() {
        return this.segments;
    }

    public void setSegmentCount(int count) {
        this.segments = count;
        this.fireChangeEvent(true);
    }

    @Override
    public List<LegendItemInfo> getLegendInfo() {
        ArrayList<LegendItemInfo> result = new ArrayList<LegendItemInfo>();
        for (Comparable<?> key : this.dataset.getKeys()) {
            String label = this.legendLabelGenerator.generateLabel(this.dataset, key);
            StandardLegendItemInfo info = new StandardLegendItemInfo(key, label, this.sectionColorSource.getColor(key));
            result.add(info);
        }
        return result;
    }

    @Override
    public void compose(World world, double xOffset, double yOffset, double zOffset) {
        double total = DataUtils.total(this.dataset);
        double r = 0.0;
        int count = this.dataset.getItemCount();
        for (int i = 0; i < count; ++i) {
            Comparable<?> key = this.dataset.getKey(i);
            Number n = (Number)this.dataset.getValue(i);
            if (n == null) continue;
            double angle = Math.PI * 2 * (n.doubleValue() / total);
            Color c = this.sectionColorSource.getColor(this.dataset.getKey(i));
            Object3D segment = Object3D.createPieSegment(this.radius, 0.0, yOffset, this.depth, r, r + angle, Math.PI / (double)this.segments, c);
            segment.setProperty("key", new KeyedValuesItemKey(key));
            world.add(segment);
            r += angle;
        }
    }

    public List<Object3D> getLabelFaces(double xOffset, double yOffset, double zOffset) {
        double total = DataUtils.total(this.dataset);
        ArrayList<Object3D> result = new ArrayList<Object3D>();
        result.add(new Dot3D(0.0f, 0.0f, 0.0f, Color.RED));
        result.add(new Dot3D(0.0f, (float)yOffset, 0.0f, Color.RED));
        double r = 0.0;
        int count = this.dataset.getItemCount();
        for (int i = 0; i < count; ++i) {
            Number n = (Number)this.dataset.getValue(i);
            double angle = 0.0;
            if (n != null) {
                angle = Math.PI * 2 * (n.doubleValue() / total);
            }
            result.addAll(Object3D.createPieLabelMarkers(this.radius * 1.2, 0.0, yOffset - this.depth * 0.05, this.depth * 1.1, r, r + angle));
            r += angle;
        }
        return result;
    }

    @Override
    public String generateToolTipText(ItemKey itemKey) {
        if (!(itemKey instanceof KeyedValuesItemKey)) {
            throw new IllegalArgumentException("The itemKey must be a ValuesItemKey instance.");
        }
        KeyedValuesItemKey vik = (KeyedValuesItemKey)itemKey;
        return this.toolTipGenerator.generateLabel(this.dataset, vik.getKey());
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PiePlot3D)) {
            return false;
        }
        PiePlot3D that = (PiePlot3D)obj;
        if (this.radius != that.radius) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        if (!this.sectionColorSource.equals(that.sectionColorSource)) {
            return false;
        }
        if (!this.sectionLabelGenerator.equals(that.sectionLabelGenerator)) {
            return false;
        }
        if (!this.sectionLabelFontSource.equals(that.sectionLabelFontSource)) {
            return false;
        }
        if (!this.sectionLabelColorSource.equals(that.sectionLabelColorSource)) {
            return false;
        }
        if (!this.legendLabelGenerator.equals(that.legendLabelGenerator)) {
            return false;
        }
        if (!this.toolTipGenerator.equals(that.toolTipGenerator)) {
            return false;
        }
        if (this.segments != that.segments) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.radius) ^ Double.doubleToLongBits(this.radius) >>> 32);
        hash = 97 * hash + (int)(Double.doubleToLongBits(this.depth) ^ Double.doubleToLongBits(this.depth) >>> 32);
        hash = 97 * hash + this.sectionColorSource.hashCode();
        hash = 97 * hash + this.sectionLabelGenerator.hashCode();
        hash = 97 * hash + this.sectionLabelFontSource.hashCode();
        hash = 97 * hash + this.sectionLabelColorSource.hashCode();
        hash = 97 * hash + this.segments;
        return hash;
    }
}

