/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.style;

import com.orsoncharts.Chart3D;
import com.orsoncharts.ChartElement;
import com.orsoncharts.ChartElementVisitor;
import com.orsoncharts.axis.Axis3D;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.marker.CategoryMarker;
import com.orsoncharts.marker.Marker;
import com.orsoncharts.marker.NumberMarker;
import com.orsoncharts.marker.RangeMarker;
import com.orsoncharts.plot.AbstractPlot3D;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.plot.PiePlot3D;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.Renderer3D;
import com.orsoncharts.renderer.category.CategoryRenderer3D;
import com.orsoncharts.renderer.xyz.XYZRenderer;
import com.orsoncharts.style.ChartStyle;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TableElementStyler;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;

public class ChartStyler
implements ChartElementVisitor {
    private ChartStyle style;

    public ChartStyler(ChartStyle style) {
        this.style = style;
    }

    @Override
    public void visit(ChartElement element) {
        if (element instanceof Chart3D) {
            Chart3D chart = (Chart3D)element;
            this.styleChart(chart);
        }
        if (element instanceof Plot3D) {
            Plot3D plot = (Plot3D)element;
            this.stylePlot(plot);
        }
        if (element instanceof Axis3D) {
            Axis3D axis = (Axis3D)element;
            this.styleAxis(axis);
        }
        if (element instanceof Renderer3D) {
            Renderer3D renderer = (Renderer3D)element;
            this.styleRenderer(renderer);
        }
        if (element instanceof Marker) {
            Marker marker = (Marker)element;
            this.styleMarker(marker);
        }
    }

    protected void styleChart(Chart3D chart) {
        chart.setBackground(this.style.getBackgroundPainter());
        TableElement chartTitle = chart.getTitle();
        if (chartTitle != null) {
            HashMap<String, Font> fontChanges = new HashMap<String, Font>();
            fontChanges.put("CHART_TITLE", this.style.getTitleFont());
            fontChanges.put("CHART_SUBTITLE", this.style.getSubtitleFont());
            HashMap<String, Color> bgChanges = new HashMap<String, Color>();
            bgChanges.put("CHART_TITLE", this.style.getTitleBackgroundColor());
            bgChanges.put("CHART_SUBTITLE", this.style.getSubtitleBackgroundColor());
            HashMap<String, Color> fgChanges = new HashMap<String, Color>();
            fgChanges.put("CHART_TITLE", this.style.getTitleColor());
            fgChanges.put("CHART_SUBTITLE", this.style.getSubtitleColor());
            TableElementStyler m1 = new TableElementStyler(fontChanges, fgChanges, bgChanges);
            chartTitle.receive(m1);
        }
        chart.setChartBoxColor(this.style.getChartBoxColor());
    }

    protected void stylePlot(Plot3D plot) {
        AbstractPlot3D p;
        if (plot instanceof PiePlot3D) {
            p = (PiePlot3D)plot;
            ((PiePlot3D)p).getSectionLabelFontSource().style(this.style.getSectionLabelFont());
            ((PiePlot3D)p).getSectionLabelColorSource().style(this.style.getSectionLabelColor());
            ((PiePlot3D)p).getSectionColorSource().style(this.style.getStandardColors());
        }
        if (plot instanceof CategoryPlot3D) {
            p = (CategoryPlot3D)plot;
            ((CategoryPlot3D)p).setGridlinesVisibleForColumns(this.style.getColumnAxisGridlinesVisible());
            ((CategoryPlot3D)p).setGridlinesVisibleForRows(this.style.getRowAxisGridlinesVisible());
            ((CategoryPlot3D)p).setGridlinesVisibleForValues(this.style.getYAxisGridlinesVisible());
            ((CategoryPlot3D)p).setGridlinePaintForRows(this.style.getGridlineColor());
            ((CategoryPlot3D)p).setGridlinePaintForColumns(this.style.getGridlineColor());
            ((CategoryPlot3D)p).setGridlinePaintForValues(this.style.getGridlineColor());
            ((CategoryPlot3D)p).setGridlineStrokeForColumns(this.style.getGridlineStroke());
            ((CategoryPlot3D)p).setGridlineStrokeForRows(this.style.getGridlineStroke());
            ((CategoryPlot3D)p).setGridlineStrokeForValues(this.style.getGridlineStroke());
        }
        if (plot instanceof XYZPlot) {
            p = (XYZPlot)plot;
            ((XYZPlot)p).setGridlinesVisibleX(this.style.getXAxisGridlinesVisible());
            ((XYZPlot)p).setGridlinesVisibleY(this.style.getYAxisGridlinesVisible());
            ((XYZPlot)p).setGridlinesVisibleZ(this.style.getZAxisGridlinesVisible());
            ((XYZPlot)p).setGridlinePaintX(this.style.getGridlineColor());
            ((XYZPlot)p).setGridlinePaintY(this.style.getGridlineColor());
            ((XYZPlot)p).setGridlinePaintZ(this.style.getGridlineColor());
            ((XYZPlot)p).setGridlineStrokeX(this.style.getGridlineStroke());
            ((XYZPlot)p).setGridlineStrokeY(this.style.getGridlineStroke());
            ((XYZPlot)p).setGridlineStrokeZ(this.style.getGridlineStroke());
        }
    }

    protected void styleAxis(Axis3D axis) {
        axis.setLabelFont(this.style.getAxisLabelFont());
        axis.setLabelColor(this.style.getAxisLabelColor());
        axis.setTickLabelFont(this.style.getAxisTickLabelFont());
        axis.setTickLabelColor(this.style.getAxisTickLabelColor());
        if (axis instanceof CategoryAxis3D) {
            this.styleCategoryAxis((CategoryAxis3D)axis);
        }
        if (axis instanceof ValueAxis3D) {
            this.styleValueAxis((ValueAxis3D)axis);
        }
    }

    protected void styleCategoryAxis(CategoryAxis3D axis) {
    }

    protected void styleValueAxis(ValueAxis3D axis) {
    }

    protected void styleRenderer(Renderer3D renderer) {
        if (renderer instanceof CategoryRenderer3D) {
            this.styleCategoryRenderer3D((CategoryRenderer3D)renderer);
        }
        if (renderer instanceof XYZRenderer) {
            this.styleXYZRenderer((XYZRenderer)renderer);
        }
    }

    protected void styleCategoryRenderer3D(CategoryRenderer3D renderer) {
        renderer.getColorSource().style(this.style.getStandardColors());
    }

    protected void styleXYZRenderer(XYZRenderer renderer) {
        renderer.getColorSource().style(this.style.getStandardColors());
    }

    protected void styleMarker(Marker marker) {
        if (marker instanceof CategoryMarker) {
            CategoryMarker cm = (CategoryMarker)marker;
            cm.setFont(this.style.getMarkerLabelFont());
            cm.setLabelColor(this.style.getMarkerLabelColor());
            cm.setLineColor(this.style.getMarkerLineColor());
            cm.setLineStroke(this.style.getMarkerLineStroke());
            cm.setFillColor(this.style.getMarkerFillColor());
        } else if (marker instanceof NumberMarker) {
            NumberMarker nm = (NumberMarker)marker;
            nm.setFont(this.style.getMarkerLabelFont());
            nm.setLabelColor(this.style.getMarkerLabelColor());
            nm.setLineColor(this.style.getMarkerLineColor());
            nm.setLineStroke(this.style.getMarkerLineStroke());
        } else if (marker instanceof RangeMarker) {
            RangeMarker rm = (RangeMarker)marker;
            rm.setFont(this.style.getMarkerLabelFont());
            rm.setLabelColor(this.style.getMarkerLabelColor());
            rm.setFillColor(this.style.getMarkerFillColor());
            rm.getStart().setFont(this.style.getMarkerLabelFont());
            rm.getStart().setLabelColor(this.style.getMarkerLabelColor());
            rm.getStart().setLineColor(this.style.getMarkerLineColor());
            rm.getStart().setLineStroke(this.style.getMarkerLineStroke());
            rm.getEnd().setFont(this.style.getMarkerLabelFont());
            rm.getEnd().setLabelColor(this.style.getMarkerLabelColor());
            rm.getEnd().setLineColor(this.style.getMarkerLineColor());
            rm.getEnd().setLineStroke(this.style.getMarkerLineStroke());
        }
    }
}

