/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.javabuilder.internal;

import com.mathworks.toolbox.javabuilder.MWArray;
import com.mathworks.toolbox.javabuilder.MWCellArray;
import com.mathworks.toolbox.javabuilder.internal.CombinedListIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public class CombinedList
extends AbstractList<Object>
implements Serializable {
    private List<Object> iFirst;
    private List<Object> iSecond;

    private static List<Object> asList(Object object) {
        if (!(object instanceof List)) {
            if (object instanceof Object[]) {
                return Arrays.asList((Object[])object);
            }
            if (object instanceof MWCellArray) {
                return new ListAdapter<MWArray>(((MWCellArray)object).asList());
            }
            return CombinedList.asList(new Object[]{object});
        }
        return (List)object;
    }

    public CombinedList(Object object, Object object2) {
        this.iFirst = CombinedList.asList(object);
        this.iSecond = CombinedList.asList(object2);
    }

    private List<Object> halfContaining(int n) {
        if (n < this.iFirst.size()) {
            return this.iFirst;
        }
        return this.iSecond;
    }

    private int indexWithinHalf(int n) {
        if (n < this.iFirst.size()) {
            return n;
        }
        return n - this.iFirst.size();
    }

    @Override
    public Object get(int n) {
        return this.halfContaining(n).get(this.indexWithinHalf(n));
    }

    @Override
    public Object set(int n, Object object) {
        return this.halfContaining(n).set(this.indexWithinHalf(n), object);
    }

    @Override
    public void add(int n, Object object) {
        this.halfContaining(n).add(this.indexWithinHalf(n), object);
    }

    @Override
    public Object remove(int n) {
        return this.halfContaining(n).remove(this.indexWithinHalf(n));
    }

    @Override
    public int size() {
        return this.iFirst.size() + this.iSecond.size();
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new CombinedListIterator(this.iFirst.listIterator(), this.iSecond.listIterator());
    }

    private static class ListAdapter<T>
    extends AbstractList<Object> {
        private List<T> iInnerList;

        public ListAdapter(List<T> list) {
            this.iInnerList = list;
        }

        @Override
        public Object get(int n) {
            return this.iInnerList.get(n);
        }

        @Override
        public Object set(int n, Object object) {
            return this.iInnerList.set(n, object);
        }

        @Override
        public int size() {
            return this.iInnerList.size();
        }
    }
}

