/*
 * Copyright (C) 2016 Mahsa Moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;

/**
 *
 * @author mahsa.moein
 */
public class FSigma_Tav extends javax.swing.JFrame{
    
    final Experiment experminet;
    
    public FSigma_Tav(Experiment exp) {
        
        initComponents(); 
        setLocationRelativeTo(null);
        setDefaultCloseOperation(FSigma_Tav.DISPOSE_ON_CLOSE);
        
        this.experminet = exp;
        this.experminet.SigmaTavShown = true;
        
        jPnl_SigmaTav.setBorder(BorderFactory.createLineBorder(Color.black));

       this.setLayout(new BorderLayout());
       this.add(jPnl_SigmaTav,BorderLayout.CENTER);
       this.add(jPnlInfo,BorderLayout.SOUTH);
       this.pack();
         
        this.addWindowListener(new java.awt.event.WindowAdapter() {
            @Override
            public void windowClosing(java.awt.event.WindowEvent windowEvent) {
                
                experminet.SigmaTavShown = false;   
                
            }
        }); 
      
        jCmbSectionName.removeAllItems();
        if(this.experminet.NumberOfSections>1 && this.experminet.NameOfSections!=null)
        {
           for(int i=0; i<experminet.NumberOfSections;i++)
           {
               jCmbSectionName.addItem(this.experminet.NameOfSections.get(i));
           } 
        }
        else
        {
            jCmbSectionName.setVisible(false);
            jLblSection.setVisible(false);
        } 
        this.jTxtIntercept.setEditable(false);
        this.jTxtMeanTav.setEditable(false);
        
        this.jTxtRMSE.setEditable(false);
        this.jTxtSlope.setEditable(false);
    }
    
    public void ShowSigmaTavPlot()
    {
        if (experminet.SigmaTavShown) { 
           
            jPnl_SigmaTav.setLayout(new BorderLayout());
            jPnl_SigmaTav.removeAll();
            jPnl_SigmaTav.repaint();
            jPnl_SigmaTav.add(experminet.SigmaTavPlot.chartPanel,BorderLayout.CENTER);
            jPnl_SigmaTav.validate();
           
            this.setPlotInfoTextBoexs(0);
        }
        else
        {
           jPnl_SigmaTav.removeAll();
           jPnl_SigmaTav.repaint();
           jPnl_SigmaTav.validate();
        }
    }
   
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPnl_SigmaTav = new javax.swing.JPanel();
        jPnlInfo = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLblMeanTav = new javax.swing.JLabel();
        jTxtSlope = new javax.swing.JTextField();
        jTxtMeanTav = new javax.swing.JTextField();
        jLblPeakNo = new javax.swing.JLabel();
        jTxtPeakNo = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        jLblSection = new javax.swing.JLabel();
        jCmbSectionName = new javax.swing.JComboBox();
        jLblIntercept = new javax.swing.JLabel();
        jTxtIntercept = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTxtRMSE = new javax.swing.JTextField();
        jBtnRemoveFilter = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Sigma_Tav Plot");
        setBounds(new java.awt.Rectangle(0, 0, 0, 0));

        jPnl_SigmaTav.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnl_SigmaTav.setPreferredSize(new java.awt.Dimension(500, 360));
        jPnl_SigmaTav.setSize(new java.awt.Dimension(500, 360));

        javax.swing.GroupLayout jPnl_SigmaTavLayout = new javax.swing.GroupLayout(jPnl_SigmaTav);
        jPnl_SigmaTav.setLayout(jPnl_SigmaTavLayout);
        jPnl_SigmaTavLayout.setHorizontalGroup(
            jPnl_SigmaTavLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 498, Short.MAX_VALUE)
        );
        jPnl_SigmaTavLayout.setVerticalGroup(
            jPnl_SigmaTavLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 358, Short.MAX_VALUE)
        );

        jPnlInfo.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlInfo.setPreferredSize(new java.awt.Dimension(500, 157));
        jPnlInfo.setSize(new java.awt.Dimension(500, 157));

        jLabel1.setText("Slope:");

        jLblMeanTav.setText("Mean Tav:");

        jTxtSlope.setPreferredSize(new java.awt.Dimension(85, 28));
        jTxtSlope.setSize(new java.awt.Dimension(85, 28));

        jTxtMeanTav.setPreferredSize(new java.awt.Dimension(85, 28));
        jTxtMeanTav.setSize(new java.awt.Dimension(85, 28));

        jLblPeakNo.setText("Peak number:");

        jTxtPeakNo.setPreferredSize(new java.awt.Dimension(85, 28));
        jTxtPeakNo.setSize(new java.awt.Dimension(85, 28));
        jTxtPeakNo.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                jTxtPeakNoKeyPressed(evt);
            }
        });

        jButton1.setText("Filter signals");
        jButton1.setPreferredSize(new java.awt.Dimension(120, 29));
        jButton1.setSize(new java.awt.Dimension(120, 29));
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLblSection.setText("Section:");

        jCmbSectionName.setModel(new javax.swing.DefaultComboBoxModel(new String[] { " ", " " }));
        jCmbSectionName.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCmbSectionNameItemStateChanged(evt);
            }
        });

        jLblIntercept.setText("Intercept:");

        jTxtIntercept.setPreferredSize(new java.awt.Dimension(85, 28));
        jTxtIntercept.setSize(new java.awt.Dimension(85, 28));

        jLabel2.setText("RMSE:");

        jTxtRMSE.setPreferredSize(new java.awt.Dimension(85, 28));
        jTxtRMSE.setSize(new java.awt.Dimension(85, 28));

        jBtnRemoveFilter.setText("Remove filter");
        jBtnRemoveFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnRemoveFilterActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPnlInfoLayout = new javax.swing.GroupLayout(jPnlInfo);
        jPnlInfo.setLayout(jPnlInfoLayout);
        jPnlInfoLayout.setHorizontalGroup(
            jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlInfoLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jLblSection)
                    .addComponent(jLabel2)
                    .addComponent(jLblPeakNo))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPnlInfoLayout.createSequentialGroup()
                        .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jTxtSlope, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTxtRMSE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTxtPeakNo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPnlInfoLayout.createSequentialGroup()
                                .addGap(91, 91, 91)
                                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLblIntercept)
                                    .addComponent(jLblMeanTav))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jTxtIntercept, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jTxtMeanTav, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(jPnlInfoLayout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 129, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jBtnRemoveFilter, javax.swing.GroupLayout.PREFERRED_SIZE, 123, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addComponent(jCmbSectionName, javax.swing.GroupLayout.PREFERRED_SIZE, 330, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(44, Short.MAX_VALUE))
        );
        jPnlInfoLayout.setVerticalGroup(
            jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlInfoLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblSection)
                    .addComponent(jCmbSectionName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(10, 10, 10)
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel1)
                    .addComponent(jTxtSlope, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLblIntercept)
                    .addComponent(jTxtIntercept, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(4, 4, 4)
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jTxtMeanTav, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLblMeanTav)
                    .addComponent(jTxtRMSE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addGap(10, 10, 10)
                .addGroup(jPnlInfoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblPeakNo)
                    .addComponent(jTxtPeakNo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnRemoveFilter))
                .addContainerGap(10, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPnlInfo, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(6, 6, 6))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(jPnl_SigmaTav, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap())))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jPnlInfo, jPnl_SigmaTav});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPnl_SigmaTav, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPnlInfo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(5, 5, 5))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jCmbSectionNameItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCmbSectionNameItemStateChanged
        // TODO add your handling code here:
        if(jCmbSectionName.getItemCount()>0)
        {
            this.setPlotInfoTextBoexs(jCmbSectionName.getSelectedIndex());
        }
    }//GEN-LAST:event_jCmbSectionNameItemStateChanged

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:       
       FilterSignals();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    private void FilterSignals()
    {
        int PeakNo = 0;
        if(jTxtPeakNo.getText().isEmpty())
        {
           JOptionPane.showMessageDialog(this, "Please enter a number in the 'Peak number' field");
           return;
        }
        try {
               PeakNo = Integer.parseInt(String.valueOf(jTxtPeakNo.getText()));

           } catch (NumberFormatException exc) {
               JOptionPane.showMessageDialog(this, "Please enter a number in the 'Peak number' field");
               jTxtPeakNo.setText("");
               return;
           }
        int SectionId = -1;
        if(jCmbSectionName.getItemCount()>0)
        {
             SectionId = jCmbSectionName.getSelectedIndex();
            this.experminet.FilterSignals(PeakNo,SectionId);
           
        }
        else
        {
            SectionId = 0;
           this.experminet.FilterSignals(PeakNo,0); 
        }
        this.setPlotInfoTextBoexs(SectionId);
    }
    
    private void jBtnRemoveFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnRemoveFilterActionPerformed
        // TODO add your handling code here:
        this.experminet.RemoveFilter();
        if(jCmbSectionName.getItemCount()>0)
        {
            this.jCmbSectionName.setSelectedIndex(0);
        }
        this.jTxtPeakNo.setText("");
        
    }//GEN-LAST:event_jBtnRemoveFilterActionPerformed

    private void jTxtPeakNoKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_jTxtPeakNoKeyPressed
        // TODO add your handling code here:
        if(evt.getKeyCode() == KeyEvent.VK_ENTER)
        {
            FilterSignals();
        }
           
    }//GEN-LAST:event_jTxtPeakNoKeyPressed

    public void setPlotInfoTextBoexs(int SectionId)
    {        
        this.jTxtSlope.setText(String.valueOf(experminet.Sigma_Tav_Slope[SectionId]));
        this.jTxtIntercept.setText(String.valueOf(experminet.Sigma_Tav_Intercept[SectionId]));
        this.jTxtRMSE.setText(String.valueOf(experminet.RMSE[SectionId]));
        this.jTxtMeanTav.setText(String.valueOf(experminet.ComputeMeanTav(SectionId))); 
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnRemoveFilter;
    private javax.swing.JButton jButton1;
    private javax.swing.JComboBox jCmbSectionName;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLblIntercept;
    private javax.swing.JLabel jLblMeanTav;
    private javax.swing.JLabel jLblPeakNo;
    private javax.swing.JLabel jLblSection;
    private javax.swing.JPanel jPnlInfo;
    private javax.swing.JPanel jPnl_SigmaTav;
    private javax.swing.JTextField jTxtIntercept;
    private javax.swing.JTextField jTxtMeanTav;
    private javax.swing.JTextField jTxtPeakNo;
    private javax.swing.JTextField jTxtRMSE;
    private javax.swing.JTextField jTxtSlope;
    // End of variables declaration//GEN-END:variables
}
