/*
 * Copyright (C) 2017 mahsa.moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

/**
 *
 * @author mahsa.moein
 */
public class DataAccess {
    
    private ArrayList<AnalysisInfo> anaInfoList;
    
    private ArrayList<SignalProfile> SignalProfileList;
    
    public boolean FillSignalInfo(Experiment exp)
    {
        if(exp!= null)
        {
            ArrayList<Signal> deleteList = new ArrayList();
            if(exp.signals!=null && !exp.signals.isEmpty() && this.anaInfoList.size()>0)
            {                              
                for (Signal sig : exp.signals) {
                    
                    int Signal_ID = sig.getSig_Id();
                    
                    for (AnalysisInfo anaInfo : this.anaInfoList) {// find out the number of sections of each signal
                        
                        if(anaInfo.Signal_ID == Signal_ID)
                        {
                            if(sig.getSig_name() == null || "".equals(sig.getSig_name()))
                            {
                                sig.setSig_name(anaInfo.Signal_Name);
                            }
                            if(sig.getNemberofSections()==0)
                            {
                                sig.NumberOfSections = anaInfo.NumberofSections;
                            }
                            break;
                        }
                    }                                         
                    for(AnalysisInfo anaInfo : this.anaInfoList) {
                        if(Signal_ID == anaInfo.Signal_ID)
                        {
                            Sections sec = new Sections(anaInfo.Section_Name, anaInfo.Section_ID, anaInfo.Signal_ID);
                            
                            for(int i = anaInfo.sec_startIndex_InSignal; i<=anaInfo.sec_EndIndex_InSignal; i++)
                            {
                                sec.section_time.add(sig.sig_time.get(i));
                                sec.section_value.add(sig.sig_value.get(i));
                                
                            }
                            if(!sec.section_time.isEmpty())
                            {
                                sec.setPeakPercent(anaInfo.PeakThreshold);
                                sec.setSpikeWidthPercent(anaInfo.SpikeWidthThreshold);
                                sec.TimeIsAddedToSection = true;
                                sec.startIndex_InSignal = anaInfo.sec_startIndex_InSignal;
                                sec.EndIndex_InSignal = anaInfo.sec_EndIndex_InSignal;
                                sec.peakIndex_Max = new ArrayList();
                                sec.peakValue_Max = new ArrayList();
                                sec.peakIndex_Min = new ArrayList();
                                sec.Next_PeakIndex_Min = new ArrayList();
                                sec.peakValue_Min = new ArrayList();
                                sec.section_Name = anaInfo.Section_Name;
                                sig.sections.add(sec);
                            }                           
                        }                         
                    }
                    if(sig.sections.size()>1){
                        sig.SignalHasOneSection = false;
                    }
                    
                    if(!sig.sections.isEmpty()){
                    
                        for(SignalProfile sigProf : this.SignalProfileList){
                            if(Signal_ID == sigProf.Signal_ID)
                            {
                                for(Sections sec : sig.sections){
                                    if(sec.getSecID() == sigProf.Section_ID)
                                    {
                                        if(sigProf.PeakIndex_Max > 0 && sigProf.PeakIndex_Max < sig.sig_value.size() &&
                                                sigProf.PeakIndex_Min>0 && sigProf.PeakIndex_Min < sig.sig_value.size()){
                                            sec.peakIndex_Max.add(sigProf.PeakIndex_Max);
                                            sec.peakValue_Max.add(sec.section_value.get(sigProf.PeakIndex_Max));
                                            sec.peakIndex_Min.add(sigProf.PeakIndex_Min);
                                            sec.peakValue_Min.add(sec.section_value.get(sigProf.PeakIndex_Min));
                                            sec.Next_PeakIndex_Min.add(sigProf.Next_PeakIndex_Min);
                                        }
                                    }                               
                                }
                            }                        
                        }                                     
                        for(Sections sec : sig.sections){ // if at least for one section peaks are found,then IsPeakFounf is true;
                            if(!sec.peakIndex_Max.isEmpty()){
                                sig.IsPeakFound = true;
                                sec.IsPeakFound = true;
                                sec.peakIndex_Min.add(sec.Next_PeakIndex_Min.get(sec.Next_PeakIndex_Min.size()-1));
                                sec.peakValue_Min.add(sec.section_value.get(sec.Next_PeakIndex_Min.get(sec.Next_PeakIndex_Min.size()-1)));
                                sec.ComputeSpikeWidthAndAMP2();
                                sec.computeISI();
                            }
                        }
                    }
                    else
                    {
                       deleteList.add(sig);
                    }
                    
                    if(sig.NumberOfSections != sig.sections.size())
                    {
                        deleteList.add(sig);
                    }
                    
                }                
                if(!deleteList.isEmpty())
                {
                    for(Signal sig: deleteList){
                        exp.signals.remove(sig);
                    }
                }                
                exp.NameOfSections = new ArrayList();
                for (Sections sec: exp.signals.get(0).sections)
                {
                    exp.NameOfSections.add(sec.section_Name);
                }
                exp.NumberOfSections = exp.NameOfSections.size();
                exp.Sigma_Tav_Slope = new double[exp.NameOfSections.size()];
                exp.Sigma_Tav_Intercept = new double[exp.NameOfSections.size()];
                exp.RMSE = new double[exp.NameOfSections.size()];
                exp.Mean_Tav = new double[exp.NameOfSections.size()];
                return true;
            }
            else
            {
                return false;
            }
        }
        else
        {
            return false;
        }
    }    
    public boolean ImportSignalProfile(String File_Path)
    {
        BufferedReader br = null;
        boolean ExceptionInReading = false;
        try {            
            String sCurrentLine;
            br = new BufferedReader(new FileReader(File_Path));            
            boolean IsHeader = true;            
            int NumberOfColumns = 0;
            String Split = "";
            int Signal_ID_column = -1;
            int Section_ID_column = -1;
            int PeakNo_column = -1;
            int PeakIndex_Max_column = -1;
            int PeakIndex_Min_column = -1;
            int Next_PeakIndex_Min_column = -1;
            this.SignalProfileList = new ArrayList<SignalProfile>();
            
            try{
                while ((sCurrentLine = br.readLine()) != null) {// read file row by row
                    SignalProfile sigProfile = null;                   
                    String[] parts = null;
                    boolean signalID_Isread = false;
                    boolean sectionID_Isread = false;
                    boolean Peak_No_Isread = false;
                    boolean peakIndex_Max_Isread = false;
                    boolean peakIndex_Min_Isread = false;
                    boolean Next_PeakIndex_Min_Isread = false;
                    if (IsHeader) {
                        if (sCurrentLine.split(",").length >1) {
                            parts = sCurrentLine.split(",");
                            Split = ",";
                        } else if (sCurrentLine.split("\t").length >1) {
                        parts = sCurrentLine.split("\t");
                        Split = "\t";
                        }                      

                        NumberOfColumns = parts.length;
                    } else {
                        if (NumberOfColumns != 0) {
                            parts = sCurrentLine.split(Split);
                            sigProfile = new SignalProfile();
                        } else {
                            break;
                        }
                    }
                    
                    for (int columnCounter = 0; columnCounter < NumberOfColumns; columnCounter++) {

                    if (IsHeader) {

                        if (String.valueOf(parts[columnCounter]).equals("signalID")) {
                            Signal_ID_column = columnCounter;
                        } else {
                            if (String.valueOf(parts[columnCounter]).equals("sectionID")) {
                                Section_ID_column = columnCounter;
                            } else {
                                if (String.valueOf(parts[columnCounter]).equals("Peak_No")) {
                                    PeakNo_column = columnCounter;
                                } else {
                                    if (String.valueOf(parts[columnCounter]).equals("peakIndex_Max")) {
                                        PeakIndex_Max_column = columnCounter;
                                    } else {
                                        if (String.valueOf(parts[columnCounter]).equals("peakIndex_Min")) {
                                             PeakIndex_Min_column= columnCounter;
                                        }
                                        else 
                                            if(String.valueOf(parts[columnCounter]).equals("Next_peakIndex_Min")){
                                                Next_PeakIndex_Min_column = columnCounter;
                                            }
                                    }
                                }
                            }
                        }
                        if(Signal_ID_column != -1 && Section_ID_column != -1 && PeakNo_column != -1
                                && PeakIndex_Max_column != -1 && PeakIndex_Min_column!=-1 && Next_PeakIndex_Min_column!= -1){                            
                            break;
                        }
                    }
                    else 
                    {                          
                        if(sigProfile != null)
                        {
                            if(columnCounter == Signal_ID_column)
                            {
                                sigProfile.Signal_ID = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                signalID_Isread = true;
                                                                
                            }
                            if(columnCounter == Section_ID_column)
                            {
                                sigProfile.Section_ID = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                sectionID_Isread = true;
                                
                            }
                            if(columnCounter == PeakNo_column)
                            {
                                sigProfile.PeakNo = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                Peak_No_Isread = true;
                            }

                            if(columnCounter == PeakIndex_Max_column)
                            {
                                sigProfile.PeakIndex_Max = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                peakIndex_Max_Isread = true;
                            }

                            if(columnCounter == PeakIndex_Min_column)
                            {
                                sigProfile.PeakIndex_Min = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                peakIndex_Min_Isread = true;                               
                            }
                            if(columnCounter == Next_PeakIndex_Min_column)
                            {
                                sigProfile.Next_PeakIndex_Min = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                Next_PeakIndex_Min_Isread = true;                              
                            }
                        }
                    }
                }
                
                if(!IsHeader && signalID_Isread && sectionID_Isread && Peak_No_Isread && 
                        peakIndex_Max_Isread && peakIndex_Min_Isread && Next_PeakIndex_Min_Isread)
                {
                    this.SignalProfileList.add(sigProfile);
                }
                
                IsHeader = false; // after reading the first row                
                                                               
                }            
            }
            catch(Exception e)
            {
               ExceptionInReading = true;
               return ExceptionInReading;
            }
        
        } catch (IOException e) {
            ExceptionInReading = true;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }               
            } catch (IOException ex) {
                ExceptionInReading = true;
            }
        }
        return ExceptionInReading;   
    }
    
    public boolean ImportAnalysisInfo(String File_Path)
    {
        BufferedReader br = null;
        boolean ExceptionInReading = false;
        try {            
            String sCurrentLine;
            br = new BufferedReader(new FileReader(File_Path));            
            boolean IsHeader = true;            
            int NumberOfColumns = 0;
            String Split = ""; 
            
            int Signal_ID_column = -1;
            int Signal_Name_column = -1;
            int NumberofSections_column = -1;
            int Section_ID_column = -1;
            int Section_Name_column = -1;
            int PeakThreshold_column = -1;
            int SWThreshold_column = -1;
            int startIndex_InSignal_column = -1;
            int EndIndex_InSignal_column = -1;
            
            try{
            this.anaInfoList = new ArrayList<>();
            while ((sCurrentLine = br.readLine()) != null) {// read file row by row
                boolean Signal_ID_Isread = false;
                boolean Signal_Name_Isread = false;
                boolean NumberofSections_Isread = false;
                boolean Section_ID_Isread = false;
                boolean Section_Name_Isread = false;
                boolean PeakThreshold_Isread = false;
                boolean SWThreshold_Isread = false;
                boolean startIndex_InSignal_Isread = false;
                boolean EndIndex_InSignal_Isread = false;
                AnalysisInfo data = null;
                String[] parts = null;
                if (IsHeader) {
                    if (sCurrentLine.split(",").length >1) {
                        parts = sCurrentLine.split(",");
                        Split = ",";
                    } else if (sCurrentLine.split("\t").length >1) {
                    parts = sCurrentLine.split("\t");
                    Split = "\t";
                    }                                          
                    NumberOfColumns = parts.length;
                } else {
                    if (NumberOfColumns != 0) {
                        parts = sCurrentLine.split(Split);
                        data = new AnalysisInfo();
                    } else {
                        break;
                    }
                }
                 boolean dataIsRead = false;               
                //For each row, iterate through all the columns                
                for (int columnCounter = 0; columnCounter < NumberOfColumns; columnCounter++) {

                    if (IsHeader) {//Find the column number of signals_InOne_file and time

                        if (String.valueOf(parts[columnCounter]).equals("Signal_ID")) {
                            Signal_ID_column = columnCounter;
                        } else {
                            if (String.valueOf(parts[columnCounter]).equals("Signal_Name")) {
                                Signal_Name_column = columnCounter;
                            } else {
                                if (String.valueOf(parts[columnCounter]).equals("NumberofSections")) {
                                    NumberofSections_column = columnCounter;
                                } else {
                                    if (String.valueOf(parts[columnCounter]).equals("Section_ID")) {
                                        Section_ID_column = columnCounter;
                                    } else {
                                        if (String.valueOf(parts[columnCounter]).equals("Section_Name")) {
                                            Section_Name_column = columnCounter;
                                        } else {
                                            if (String.valueOf(parts[columnCounter]).equals("PeakThreshold")) {
                                                PeakThreshold_column = columnCounter;
                                            } else {
                                                if (String.valueOf(parts[columnCounter]).equals("startIndex_InSignal")) {
                                                    startIndex_InSignal_column = columnCounter;
                                                } else {
                                                    if (String.valueOf(parts[columnCounter]).equals("EndIndex_InSignal")) {
                                                        EndIndex_InSignal_column = columnCounter;                                                      
                                                    }else{
                                                        if(String.valueOf(parts[columnCounter]).equals("SpikeWidthThreshold"))
                                                        {
                                                           SWThreshold_column =  columnCounter;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        if(Signal_ID_column != -1 && Signal_Name_column != -1 && NumberofSections_column != -1 &&
                            Section_ID_column != -1 && Section_Name_column != -1 && PeakThreshold_column != -1 &&
                            startIndex_InSignal_column != -1 && EndIndex_InSignal_column != -1 && SWThreshold_column!=-1){                            
                            break;
                        }
                    }
                    else 
                    {                          
                        if(data != null)
                        {
                            if(columnCounter == Signal_ID_column)
                            {
                                data.Signal_ID = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                Signal_ID_Isread = true;
                                                                
                            }
                            if(columnCounter == Signal_Name_column)
                            {
                                data.Signal_Name = String.valueOf(parts[columnCounter]);
                                Signal_Name_Isread = true;
                                
                            }
                            if(columnCounter == NumberofSections_column)
                            {
                                data.NumberofSections = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                NumberofSections_Isread = true;
                            }

                            if(columnCounter == Section_ID_column)
                            {
                                data.Section_ID = Integer.valueOf(String.valueOf(parts[columnCounter]));
                                Section_ID_Isread = true;
                            }

                            if(columnCounter == Section_Name_column)
                            {
                                data.Section_Name = String.valueOf(parts[columnCounter]);
                                Section_Name_Isread = true;                               
                            }
                            if(columnCounter == PeakThreshold_column)
                            {
                                data.PeakThreshold = Double.parseDouble(String.valueOf(parts[columnCounter]));
                                PeakThreshold_Isread = true;
                            }
                            
                            if(columnCounter == SWThreshold_column)
                            {
                                data.SpikeWidthThreshold = Double.parseDouble(String.valueOf(parts[columnCounter]));
                                SWThreshold_Isread = true;
                            }
                            
                            if(columnCounter == startIndex_InSignal_column)
                            {
                                data.sec_startIndex_InSignal = Integer.parseInt(Utils.RemoveFloats(String.valueOf(parts[columnCounter])));
                                startIndex_InSignal_Isread = true;
                            }

                            if(columnCounter == EndIndex_InSignal_column)
                            {
                                data.sec_EndIndex_InSignal = Integer.parseInt(Utils.RemoveFloats(String.valueOf(parts[columnCounter])));
                                EndIndex_InSignal_Isread = true;
                            }
                        }
                    }
                }
                
                if(!IsHeader && Signal_ID_Isread && Signal_Name_Isread && NumberofSections_Isread && Section_ID_Isread &&
                      Section_Name_Isread && PeakThreshold_Isread && startIndex_InSignal_Isread && EndIndex_InSignal_Isread
                        && SWThreshold_Isread)
                {
                    this.anaInfoList.add(data);
                }
                
                IsHeader = false; // after reading the first row                
            }                               
            }
            
            catch(Exception e)
            {
               ExceptionInReading = true;
               return ExceptionInReading;
            }

        } catch (IOException e) {
            ExceptionInReading = true;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }               
            } catch (IOException ex) {
                ExceptionInReading = true;
            }
        }
        return ExceptionInReading;        
    }
    
    
    public boolean ImportData(String File_Path, Experiment exp) {// read signals in one file
           
        ArrayList<Signal> signals_InOne_file = null;
        ArrayList<Double> signalTime_InOne_file = null;

        BufferedReader br = null;
        boolean ExceptionInReading = false;

        try {
            signals_InOne_file = new ArrayList<>();
            signalTime_InOne_file = new ArrayList<>();
            String sCurrentLine;

            br = new BufferedReader(new FileReader(File_Path));
            int NumberOfSignalsInOneFile = 0;
            boolean IsHeader = true;
            int Time_columnNo = -1;// each file should have its own time column
            int NumberOfColumns = 0;
            String Split = "";
            //boolean EXPtime_IsFilled_from_this_File = false;
            try{
            while ((sCurrentLine = br.readLine()) != null) {// read file row by row

                String[] parts = null;
                if (IsHeader) {
                    if (sCurrentLine.split(",").length >1) {
                        parts = sCurrentLine.split(",");
                        Split = ",";
                    } else if (sCurrentLine.split("\t").length >1) {
                    parts = sCurrentLine.split("\t");
                    Split = "\t";
                    }                      
                    
                    NumberOfColumns = parts.length;
                } else {
                    if (NumberOfColumns != 0) {
                        parts = sCurrentLine.split(Split);
                    } else {
                        break;
                    }
                }
                //For each row, iterate through all the columns
                
                for (int columnCounter = 0; columnCounter < NumberOfColumns; columnCounter++) {
                    
                    if (!Utils.IsDataNumeric(parts[columnCounter])) // if data is not numeric, then it is string
                    {
                        if (IsHeader) {//Find the column number of signals_InOne_file and time

                            if (String.valueOf(parts[columnCounter]).contains("Signal")) {
                                int SignalIndex = Integer.parseInt(String.valueOf(parts[columnCounter]).substring(parts[columnCounter].indexOf("-")+1));
                                NumberOfSignalsInOneFile++;                            
                                Signal s = new Signal(SignalIndex, columnCounter,"");
                                signals_InOne_file.add(s);
                            }
                            
                            if (String.valueOf(parts[columnCounter]).equals("Time")) {
                                Time_columnNo = columnCounter;
                            }
                        }
                    } else // data is numeric
                    {
                        if (!IsHeader) {
                            boolean Cell_Is_signal = false;
                            for (int i = 0; i < NumberOfSignalsInOneFile; i++) {
                                if (columnCounter == signals_InOne_file.get(i).getColumnNo()) {
                                    signals_InOne_file.get(i).Origin_sig_value.add(Double.parseDouble(String.valueOf(parts[columnCounter])));
                                    Cell_Is_signal = true;
                                    break;
                                }
                            }
                            if (!Cell_Is_signal) // maybe data is time 
                            {
                                if (columnCounter == Time_columnNo) { // data is time
                                    
                                    signalTime_InOne_file.add(Double.parseDouble(String.valueOf(parts[columnCounter])));
                                }
                              
                            }
                        }
                    }
                }
                
            IsHeader = false; // after reading the first row   
            }            
                   
            }
            
            catch(Exception e)
            {
               ExceptionInReading = true;
               return ExceptionInReading;
            }
            // one cvs file is read. we have the signals_InOne_file and the time.
            // we should now assign signals to experiment
                        
            if(!signalTime_InOne_file.isEmpty() && !signals_InOne_file.isEmpty())
            {
                for (Signal sig : signals_InOne_file) {
                    if(sig.Origin_sig_value.size() == signalTime_InOne_file.size() )
                    {
                        for(int i=0; i<signalTime_InOne_file.size();i++)
                        {
                            sig.Origin_sig_time.add(signalTime_InOne_file.get(i));
                        }
                    }
                }
                for (Signal signals_InOne_file1 : signals_InOne_file) {

                    exp.signals.add(signals_InOne_file1);

                }
            }

        } catch (IOException e) {
            ExceptionInReading = true;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
                signals_InOne_file = null;
                signalTime_InOne_file = null;
                
                
            } catch (IOException ex) {
                ExceptionInReading = true;
            }
        }
        return ExceptionInReading;

    }
    
}
