/*
 * Copyright (C) 2018 mahsa.moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

/**
 *
 * @author mahsa.moein
 */
public class FrmComputeOptimumTau extends javax.swing.JFrame {

    Experiment exp;
    SignalPlot signalPlot_First;
    SignalPlot signalPlot_Second;
    
    public FrmComputeOptimumTau(Experiment exp) {
        initComponents();
        
        setLocationRelativeTo(null);
        setDefaultCloseOperation(FrmCorrelationIntensity.DISPOSE_ON_CLOSE);
        SetLayout();
        
        this.exp = exp;        
        for(Signal sig: this.exp.signals)
        {
            this.jCbxFirstSig.addItem(sig.getSig_name());           
            this.jCbxSecondSig.addItem(sig.getSig_name());
        }  
        this.jCbxSecondSig.setSelectedIndex(1);
        
        signalPlot_First = exp.signals.get(0).createSignalPlotWithDot(exp);
        signalPlot_Second = exp.signals.get(1).createSignalPlotWithDot(exp);
                
        jPnlFirstSignal.setLayout(new BorderLayout());
        jPnlFirstSignal.removeAll();
        jPnlFirstSignal.repaint();
        jPnlFirstSignal.add(this.signalPlot_First.Signalcpanel,BorderLayout.CENTER);
        jPnlFirstSignal.validate();
               
        jPnlSecondSignal.setLayout(new BorderLayout());
        jPnlSecondSignal.removeAll();
        jPnlSecondSignal.repaint();
        jPnlSecondSignal.add(this.signalPlot_Second.Signalcpanel,BorderLayout.CENTER);
        jPnlSecondSignal.validate();
                
    }   
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPnlleft = new javax.swing.JPanel();
        jPnlControl = new javax.swing.JPanel();
        jLblTauTo = new javax.swing.JLabel();
        jTxtTauTo = new javax.swing.JTextField();
        jLblTauFrom = new javax.swing.JLabel();
        jTxtTauFrom = new javax.swing.JTextField();
        jLblSig2 = new javax.swing.JLabel();
        jCbxSecondSig = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        jCbxFirstSig = new javax.swing.JComboBox();
        jBtnCorrAllSignals = new javax.swing.JButton();
        jBtnCorr2Sig1 = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLblOpTau = new javax.swing.JLabel();
        jLblOpCor = new javax.swing.JLabel();
        jPnlPlots = new javax.swing.JPanel();
        jPnlFirstSignal = new javax.swing.JPanel();
        jPnlSecondSignal = new javax.swing.JPanel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Compute Optimum Tau");
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                formComponentResized(evt);
            }
        });

        jPnlleft.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlleft.setPreferredSize(new java.awt.Dimension(370, 493));
        jPnlleft.setSize(new java.awt.Dimension(370, 493));

        jPnlControl.setPreferredSize(new java.awt.Dimension(365, 410));
        jPnlControl.setSize(new java.awt.Dimension(365, 410));

        jLblTauTo.setText("Tau To:");

        jTxtTauTo.setPreferredSize(new java.awt.Dimension(100, 26));
        jTxtTauTo.setSize(new java.awt.Dimension(100, 26));

        jLblTauFrom.setText("Tau From:");

        jTxtTauFrom.setPreferredSize(new java.awt.Dimension(100, 26));
        jTxtTauFrom.setSize(new java.awt.Dimension(100, 26));

        jLblSig2.setText("Second signal:");

        jCbxSecondSig.setPreferredSize(new java.awt.Dimension(185, 27));
        jCbxSecondSig.setSize(new java.awt.Dimension(185, 27));
        jCbxSecondSig.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCbxSecondSigItemStateChanged(evt);
            }
        });

        jLabel1.setText("First signal:");

        jCbxFirstSig.setPreferredSize(new java.awt.Dimension(185, 27));
        jCbxFirstSig.setSize(new java.awt.Dimension(185, 27));
        jCbxFirstSig.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCbxFirstSigItemStateChanged(evt);
            }
        });

        jBtnCorrAllSignals.setText("Compute and save optimum Tau for all signals");
        jBtnCorrAllSignals.setPreferredSize(new java.awt.Dimension(350, 40));
        jBtnCorrAllSignals.setSize(new java.awt.Dimension(350, 40));
        jBtnCorrAllSignals.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCorrAllSignalsActionPerformed(evt);
            }
        });

        jBtnCorr2Sig1.setText("Compute optimum Tau for selected signals");
        jBtnCorr2Sig1.setPreferredSize(new java.awt.Dimension(350, 40));
        jBtnCorr2Sig1.setSize(new java.awt.Dimension(350, 40));
        jBtnCorr2Sig1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCorr2Sig1ActionPerformed(evt);
            }
        });

        jLabel2.setText("Optimum Tau is:");

        jLabel3.setText("Optimum correlation is:");

        jLblOpTau.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLblOpTau.setPreferredSize(new java.awt.Dimension(100, 25));
        jLblOpTau.setSize(new java.awt.Dimension(100, 25));

        jLblOpCor.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLblOpCor.setPreferredSize(new java.awt.Dimension(100, 25));
        jLblOpCor.setSize(new java.awt.Dimension(100, 25));

        javax.swing.GroupLayout jPnlControlLayout = new javax.swing.GroupLayout(jPnlControl);
        jPnlControl.setLayout(jPnlControlLayout);
        jPnlControlLayout.setHorizontalGroup(
            jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPnlControlLayout.createSequentialGroup()
                        .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1)
                            .addComponent(jLblSig2)
                            .addComponent(jLblTauFrom)
                            .addComponent(jLblTauTo))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCbxFirstSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jCbxSecondSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTxtTauFrom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTxtTauTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jBtnCorr2Sig1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnCorrAllSignals, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPnlControlLayout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLblOpTau, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPnlControlLayout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLblOpCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(9, Short.MAX_VALUE))
        );
        jPnlControlLayout.setVerticalGroup(
            jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jCbxFirstSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(15, 15, 15)
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblSig2)
                    .addComponent(jCbxSecondSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(15, 15, 15)
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblTauFrom)
                    .addComponent(jTxtTauFrom, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblTauTo)
                    .addComponent(jTxtTauTo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(jBtnCorr2Sig1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLblOpTau, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPnlControlLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jLblOpCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 30, Short.MAX_VALUE)
                .addComponent(jBtnCorrAllSignals, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(48, 48, 48))
        );

        javax.swing.GroupLayout jPnlleftLayout = new javax.swing.GroupLayout(jPnlleft);
        jPnlleft.setLayout(jPnlleftLayout);
        jPnlleftLayout.setHorizontalGroup(
            jPnlleftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jPnlControl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        jPnlleftLayout.setVerticalGroup(
            jPnlleftLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlleftLayout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addComponent(jPnlControl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(79, Short.MAX_VALUE))
        );

        jPnlPlots.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnlPlots.setPreferredSize(new java.awt.Dimension(552, 493));
        jPnlPlots.setSize(new java.awt.Dimension(552, 493));

        jPnlFirstSignal.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnlFirstSignal.setPreferredSize(new java.awt.Dimension(550, 245));
        jPnlFirstSignal.setSize(new java.awt.Dimension(550, 245));

        javax.swing.GroupLayout jPnlFirstSignalLayout = new javax.swing.GroupLayout(jPnlFirstSignal);
        jPnlFirstSignal.setLayout(jPnlFirstSignalLayout);
        jPnlFirstSignalLayout.setHorizontalGroup(
            jPnlFirstSignalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 548, Short.MAX_VALUE)
        );
        jPnlFirstSignalLayout.setVerticalGroup(
            jPnlFirstSignalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 243, Short.MAX_VALUE)
        );

        jPnlSecondSignal.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnlSecondSignal.setPreferredSize(new java.awt.Dimension(550, 245));
        jPnlSecondSignal.setSize(new java.awt.Dimension(550, 245));

        javax.swing.GroupLayout jPnlSecondSignalLayout = new javax.swing.GroupLayout(jPnlSecondSignal);
        jPnlSecondSignal.setLayout(jPnlSecondSignalLayout);
        jPnlSecondSignalLayout.setHorizontalGroup(
            jPnlSecondSignalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 548, Short.MAX_VALUE)
        );
        jPnlSecondSignalLayout.setVerticalGroup(
            jPnlSecondSignalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 243, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPnlPlotsLayout = new javax.swing.GroupLayout(jPnlPlots);
        jPnlPlots.setLayout(jPnlPlotsLayout);
        jPnlPlotsLayout.setHorizontalGroup(
            jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlPlotsLayout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addGroup(jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPnlFirstSignal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPnlSecondSignal, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, 0))
        );
        jPnlPlotsLayout.setVerticalGroup(
            jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlPlotsLayout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addComponent(jPnlFirstSignal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, 0)
                .addComponent(jPnlSecondSignal, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 1, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addComponent(jPnlleft, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE)
                .addComponent(jPnlPlots, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(0, 0, 0)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPnlleft, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPnlPlots, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 0, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private boolean CheckInputs()
    {
       boolean feildsOK = true;
        try {
            if (!"".equals(jTxtTauFrom.getText())) {
                Float.parseFloat(String.valueOf(jTxtTauFrom.getText()));
            }
            else
            {
                JOptionPane.showMessageDialog(this, "Please enter a number in the 'Tau From' field.");
                return false;
            }
        } catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "Please enter a number in the 'Tau From' field.");
            jTxtTauFrom.requestFocus();
            return false;
        }
                 
       try {
            if (!"".equals(jTxtTauTo.getText())) {
                Float.parseFloat(String.valueOf(jTxtTauTo.getText()));
            }
            else
            {
               JOptionPane.showMessageDialog(this, "Please enter a number in the 'Tau To' field."); 
               return false;
            }
        } catch (NumberFormatException exc) {
            JOptionPane.showMessageDialog(this, "Please enter a number in the 'Tau To' field.");
            jTxtTauTo.requestFocus();
            return false;
        }
                 
        if(Float.parseFloat(String.valueOf(jTxtTauFrom.getText())) > Float.parseFloat(String.valueOf(jTxtTauTo.getText())))
        {
           JOptionPane.showMessageDialog(this, "Tau From should be smaller than Tau To.");
           return false;
        }
        
        if(Float.parseFloat(String.valueOf(jTxtTauFrom.getText())) <= 0.0)
        {
           JOptionPane.showMessageDialog(this, "Tau From should be a number bigger than zero.");
           return false; 
        }
        
        if(Float.parseFloat(String.valueOf(jTxtTauTo.getText())) <= 0.0)
        {
           JOptionPane.showMessageDialog(this, "Tau To should be a number bigger than zero.");
           return false; 
        }
        
        return feildsOK;
    }
    
    private void jBtnCorrAllSignalsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCorrAllSignalsActionPerformed
    // TODO add your handling code here:
        if(CheckInputs())
        {
            float TauFrom =  Float.parseFloat(String.valueOf(jTxtTauFrom.getText()));
            float TauTo = Float.parseFloat(String.valueOf(jTxtTauTo.getText()));

            this.exp.FirstSignal = new ArrayList();
            this.exp.SecondSignal = new ArrayList();
            this.exp.OptCorrelation = new ArrayList();
            this.exp.OptTau = new ArrayList();

            for(int i=0; i<exp.signals.size(); i++)
            {
                Signal sig1 = exp.signals.get(i);
                double[] sig1_Intensity = Utils.convertDoubleArrayListToArray(sig1.sig_value);
                for(int j=i+1; j<exp.signals.size(); j++)
                {
                   Signal sig2 = exp.signals.get(j);
                   double[] sig2_Intensity = Utils.convertDoubleArrayListToArray(sig2.sig_value);
                   int IndexTauFrom = Utils.findClosetTimeIndex(TauFrom, sig2.sig_time);
                   int IndexTauTo = Utils.findClosetTimeIndex(TauTo, sig2.sig_time);

                   int optimumTauIndex = -1;
                    double OptimumCorrelation = -1;
                    for(int k = IndexTauFrom; k<= IndexTauTo; k++)
                    {
                        double dataPercentage = (sig1_Intensity.length - k +1.0) / sig1_Intensity.length;

                        if(dataPercentage >= 0.7)
                        {
                            double[] newSig1 = Utils.CutArrayFromBegining(sig1_Intensity,k);
                            double[] newSig2 = Utils.CutarrayFRomEnd(sig2_Intensity, k);               
                            if(newSig1.length == newSig2.length)
                            {
                                double correlation = Utils.getCorrelation(newSig1, newSig2);
                                if(OptimumCorrelation < correlation)
                                {
                                    OptimumCorrelation = correlation;
                                    optimumTauIndex = k;
                                }
                            }
                        }
                    }
                    this.exp.FirstSignal.add(i);
                    this.exp.SecondSignal.add(j);
                    this.exp.OptCorrelation.add(OptimumCorrelation);
                    this.exp.OptTau.add(optimumTauIndex);                
                }
            }

            //write information in a file
            FrmSaveDialog frmsave = new FrmSaveDialog(this.exp, Utils.SaveButton.SaveOptimumCorrelationAndTau);
            frmsave.setVisible(true);        
        }        
    }//GEN-LAST:event_jBtnCorrAllSignalsActionPerformed

    private void jBtnCorr2Sig1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCorr2Sig1ActionPerformed

        if(CheckInputs())
        {
            float TauFrom =  Float.parseFloat(String.valueOf(jTxtTauFrom.getText()));
            float TauTo = Float.parseFloat(String.valueOf(jTxtTauTo.getText())); 

            Signal sig1 = exp.signals.get(jCbxFirstSig.getSelectedIndex());
            Signal sig2 = exp.signals.get(jCbxSecondSig.getSelectedIndex());

            double[] sig1_Intensity = Utils.convertDoubleArrayListToArray(sig1.sig_value);
            double[] sig2_Intensity = Utils.convertDoubleArrayListToArray(sig2.sig_value);

            int IndexTauFrom = Utils.findClosetTimeIndex(TauFrom, sig2.sig_time);
            int IndexTauTo = Utils.findClosetTimeIndex(TauTo, sig2.sig_time);
            int optimumTauIndex = -1;
            double OptimumCorrelation = -1;
            for(int i = IndexTauFrom; i<= IndexTauTo; i++)
            {
                double dataPercentage = (sig1_Intensity.length - i +1.0) / sig1_Intensity.length;

                if(dataPercentage >= 0.7)
                {
                    double[] newSig1 = Utils.CutArrayFromBegining(sig1_Intensity,i);
                    double[] newSig2 = Utils.CutarrayFRomEnd(sig2_Intensity, i);               
                    if(newSig1.length == newSig2.length)
                    {
                        double correlation = Utils.getCorrelation(newSig1, newSig2);
                        if(OptimumCorrelation < correlation)
                        {
                            OptimumCorrelation = correlation;
                            optimumTauIndex = i;
                        }
                    }
                }
            }        
            jLblOpTau.setText(" " + String.valueOf(sig2.sig_time.get(optimumTauIndex)));
            jLblOpCor.setText(" " + String.valueOf(OptimumCorrelation));       
        }  
    }//GEN-LAST:event_jBtnCorr2Sig1ActionPerformed
    
    private void formComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentResized
        // TODO add your handling code here:
        int Height = this.jPnlPlots.getHeight();
        int width = this.jPnlPlots.getWidth();
        int HFirstPlot = (int) Math.floor(0.5 * Height);       
        this.jPnlFirstSignal.setPreferredSize(new Dimension(width, HFirstPlot));
        this.jPnlSecondSignal.setPreferredSize(new Dimension(width, HFirstPlot));
        
    }//GEN-LAST:event_formComponentResized

    private void jCbxFirstSigItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCbxFirstSigItemStateChanged
        
        signalPlot_First = exp.signals.get(jCbxFirstSig.getSelectedIndex()).createSignalPlotWithDot(exp);
        jPnlFirstSignal.setLayout(new BorderLayout());
        jPnlFirstSignal.removeAll();
        jPnlFirstSignal.repaint();
        jPnlFirstSignal.add(this.signalPlot_First.Signalcpanel,BorderLayout.CENTER);
        jPnlFirstSignal.validate();
    }//GEN-LAST:event_jCbxFirstSigItemStateChanged

    private void jCbxSecondSigItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCbxSecondSigItemStateChanged
        signalPlot_Second = exp.signals.get(jCbxSecondSig.getSelectedIndex()).createSignalPlotWithDot(exp);
        jPnlSecondSignal.setLayout(new BorderLayout());
        jPnlSecondSignal.removeAll();
        jPnlSecondSignal.repaint();
        jPnlSecondSignal.add(this.signalPlot_Second.Signalcpanel,BorderLayout.CENTER);
        jPnlSecondSignal.validate();
    }//GEN-LAST:event_jCbxSecondSigItemStateChanged
     
    private void SetLayout() {
        
        this.setLayout(new BorderLayout());
        this.add(jPnlleft, BorderLayout.WEST);
        
        jPnlleft.setLayout(new BorderLayout());
        jPnlleft.add(jPnlControl, BorderLayout.NORTH);
        jPnlleft.setPreferredSize(new Dimension(365, 410));
                
        this.add(jPnlPlots, BorderLayout.CENTER);
        jPnlPlots.setLayout(new BorderLayout());
        jPnlPlots.setPreferredSize(new Dimension(552,493));
        
        jPnlPlots.add(jPnlFirstSignal, BorderLayout.NORTH);
        jPnlFirstSignal.setPreferredSize(new Dimension(550,245));
        jPnlPlots.add(jPnlSecondSignal, BorderLayout.CENTER);
        jPnlSecondSignal.setPreferredSize(new Dimension(550,245));
        this.pack();
    }

    
    
   
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnCorr2Sig1;
    private javax.swing.JButton jBtnCorrAllSignals;
    private javax.swing.JComboBox jCbxFirstSig;
    private javax.swing.JComboBox jCbxSecondSig;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLblOpCor;
    private javax.swing.JLabel jLblOpTau;
    private javax.swing.JLabel jLblSig2;
    private javax.swing.JLabel jLblTauFrom;
    private javax.swing.JLabel jLblTauTo;
    private javax.swing.JPanel jPnlControl;
    private javax.swing.JPanel jPnlFirstSignal;
    private javax.swing.JPanel jPnlPlots;
    private javax.swing.JPanel jPnlSecondSignal;
    private javax.swing.JPanel jPnlleft;
    private javax.swing.JTextField jTxtTauFrom;
    private javax.swing.JTextField jTxtTauTo;
    // End of variables declaration//GEN-END:variables
}
