/*
 * Copyright (C) 2017 mahsa.moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;

import java.awt.BorderLayout;
import java.util.Objects;

/**
 *
 * @author mahsa.moein
 */
public class FrmCorrelationIntensity extends javax.swing.JFrame {
    
    Experiment exp;
    
    public FrmCorrelationIntensity(Experiment exp) {        
        initComponents();
        setLocationRelativeTo(null);
        setDefaultCloseOperation(FrmCorrelationIntensity.DISPOSE_ON_CLOSE);
        
        this.exp = exp;        
        for(Signal sig: this.exp.signals)
        {
            this.jCbxSigX.addItem(sig.getSig_name());           
            this.jCbxYSig.addItem(sig.getSig_name());
        }        
        
        if(this.exp.NumberOfSections >1)
        {
            this.jCbxRegion.addItem("None");
            for(String SecName: this.exp.NameOfSections)
            {
                this.jCbxRegion.addItem(SecName);
            }
            jBtnSaveSecCor.setEnabled(true);
            
        }
        else
        {
            this.jCbxRegion.setEnabled(false);
            this.jLblSec.setEnabled(false);
            jBtnSaveSecCor.setEnabled(false);
        }       
    }

    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPnlControls = new javax.swing.JPanel();
        jLblXSig = new javax.swing.JLabel();
        jLblYSig = new javax.swing.JLabel();
        jLblSec = new javax.swing.JLabel();
        jCbxSigX = new javax.swing.JComboBox();
        jCbxYSig = new javax.swing.JComboBox();
        jCbxRegion = new javax.swing.JComboBox();
        jBtnPlot = new javax.swing.JButton();
        jBtnSaveSigCor = new javax.swing.JButton();
        jBtnSaveSecCor = new javax.swing.JButton();
        jPnlPlot = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLblCor = new javax.swing.JLabel();
        jLblSlope = new javax.swing.JLabel();
        jLblIntercept = new javax.swing.JLabel();
        jLblRMSE = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Plot Correlation between Signals");
        setName("FrmCorrelation"); // NOI18N

        jPnlControls.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlControls.setPreferredSize(new java.awt.Dimension(422, 215));
        jPnlControls.setSize(new java.awt.Dimension(422, 215));

        jLblXSig.setText("First Signal:");
        jLblXSig.setToolTipText("");
        jLblXSig.setPreferredSize(new java.awt.Dimension(100, 16));
        jLblXSig.setSize(new java.awt.Dimension(100, 16));

        jLblYSig.setText("Second Signal:");
        jLblYSig.setToolTipText("");
        jLblYSig.setPreferredSize(new java.awt.Dimension(100, 16));
        jLblYSig.setSize(new java.awt.Dimension(100, 16));

        jLblSec.setText("Section name:");
        jLblSec.setToolTipText("");
        jLblSec.setPreferredSize(new java.awt.Dimension(100, 16));
        jLblSec.setSize(new java.awt.Dimension(100, 16));

        jCbxSigX.setPreferredSize(new java.awt.Dimension(200, 27));
        jCbxSigX.setSize(new java.awt.Dimension(200, 27));

        jCbxYSig.setPreferredSize(new java.awt.Dimension(200, 27));
        jCbxYSig.setSize(new java.awt.Dimension(200, 27));

        jCbxRegion.setSelectedIndex(-1);
        jCbxRegion.setPreferredSize(new java.awt.Dimension(200, 27));
        jCbxRegion.setSize(new java.awt.Dimension(200, 27));

        jBtnPlot.setText("Plot");
        jBtnPlot.setSize(new java.awt.Dimension(75, 29));
        jBtnPlot.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnPlotActionPerformed(evt);
            }
        });

        jBtnSaveSigCor.setLabel("Save signal correlations");
        jBtnSaveSigCor.setPreferredSize(new java.awt.Dimension(186, 35));
        jBtnSaveSigCor.setSize(new java.awt.Dimension(186, 29));
        jBtnSaveSigCor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnSaveSigCorActionPerformed(evt);
            }
        });

        jBtnSaveSecCor.setLabel("Save section correlations");
        jBtnSaveSecCor.setPreferredSize(new java.awt.Dimension(186, 35));
        jBtnSaveSecCor.setSize(new java.awt.Dimension(186, 35));
        jBtnSaveSecCor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnSaveSecCorActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPnlControlsLayout = new javax.swing.GroupLayout(jPnlControls);
        jPnlControls.setLayout(jPnlControlsLayout);
        jPnlControlsLayout.setHorizontalGroup(
            jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlsLayout.createSequentialGroup()
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPnlControlsLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLblSec, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLblYSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLblXSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPnlControlsLayout.createSequentialGroup()
                        .addGap(103, 103, 103)
                        .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jBtnPlot, javax.swing.GroupLayout.PREFERRED_SIZE, 135, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jCbxSigX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jCbxYSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jCbxRegion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(jPnlControlsLayout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jBtnSaveSigCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jBtnSaveSecCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(34, Short.MAX_VALUE))
        );

        jPnlControlsLayout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jCbxRegion, jCbxSigX, jCbxYSig});

        jPnlControlsLayout.setVerticalGroup(
            jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLblXSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCbxSigX, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(23, 23, 23)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblYSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCbxYSig, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(26, 26, 26)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLblSec, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCbxRegion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jBtnPlot)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnSaveSigCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnSaveSecCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(31, 31, 31))
        );

        jPnlPlot.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlPlot.setPreferredSize(new java.awt.Dimension(490, 386));
        jPnlPlot.setSize(new java.awt.Dimension(490, 386));

        javax.swing.GroupLayout jPnlPlotLayout = new javax.swing.GroupLayout(jPnlPlot);
        jPnlPlot.setLayout(jPnlPlotLayout);
        jPnlPlotLayout.setHorizontalGroup(
            jPnlPlotLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 486, Short.MAX_VALUE)
        );
        jPnlPlotLayout.setVerticalGroup(
            jPnlPlotLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 382, Short.MAX_VALUE)
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel1.setPreferredSize(new java.awt.Dimension(422, 110));
        jPanel1.setSize(new java.awt.Dimension(100, 110));

        jLabel1.setText("Correlaion:");

        jLabel2.setText("Slope:");

        jLabel3.setText("Intercept:");
        jLabel3.setToolTipText("");

        jLabel4.setText("RMSE:");
        jLabel4.setToolTipText("");

        jLblCor.setPreferredSize(new java.awt.Dimension(100, 20));
        jLblCor.setSize(new java.awt.Dimension(100, 16));

        jLblSlope.setPreferredSize(new java.awt.Dimension(100, 20));
        jLblSlope.setSize(new java.awt.Dimension(100, 20));

        jLblIntercept.setPreferredSize(new java.awt.Dimension(100, 20));
        jLblIntercept.setSize(new java.awt.Dimension(100, 20));

        jLblRMSE.setPreferredSize(new java.awt.Dimension(100, 20));
        jLblRMSE.setSize(new java.awt.Dimension(100, 20));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jLabel3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLblCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLblIntercept, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(70, 70, 70)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(jLabel4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLblSlope, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLblRMSE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(23, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel1)
                    .addComponent(jLblCor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jLblSlope, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(31, 31, 31)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel3)
                    .addComponent(jLblIntercept, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4)
                    .addComponent(jLblRMSE, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(29, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addComponent(jPnlControls, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(3, 3, 3))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(3, 3, 3)))
                .addComponent(jPnlPlot, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(3, 3, 3)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPnlPlot, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPnlControls, javax.swing.GroupLayout.DEFAULT_SIZE, 273, Short.MAX_VALUE)
                        .addGap(3, 3, 3)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(3, 3, 3))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnPlotActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnPlotActionPerformed
        
        Signal s1 = this.exp.signals.get(this.jCbxSigX.getSelectedIndex());       
        Signal s2 = this.exp.signals.get(this.jCbxYSig.getSelectedIndex());        
        PlotPoints IntensityCorrelationPlot = new PlotPoints();        
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        String ComponentID = "";
        
        // signals should start and end in the same time point
        if(Objects.equals(s1.sig_time.get(0), s2.sig_time.get(0)) && Objects.equals(s1.sig_time.get(s1.sig_time.size()-1), s2.sig_time.get(s1.sig_time.size()-1)))
        {
            if(!this.jCbxRegion.isEnabled() || this.jCbxRegion.getSelectedIndex() == 0)
            {
                minX = Utils.findMin(s1.sig_value);
                maxX = Utils.findMax(s1.sig_value);
                minY = Utils.findMin(s2.sig_value);
                maxY = Utils.findMax(s2.sig_value);                
                // whole signal is considered as one section
                //SectionID starts from zero
                ComponentID = "0_CorrelationIntensityPlot"; 
                IntensityCorrelationPlot.AddPlot(this.exp, Utils.convertDoubleArrayListToArray(s1.sig_value), Utils.convertDoubleArrayListToArray(s2.sig_value), 
                        ComponentID, minX, minY, maxX, maxY, s1.getSig_name() + " Intensity", s2.getSig_name() + " Intensity", false, 
                        true,PlotPoints.plotType.CorrelationIntensityPlot);
                
                this.jLblCor.setText(String.valueOf(Utils.getCorrelation(Utils.convertDoubleArrayListToArray(s1.sig_value), 
                        Utils.convertDoubleArrayListToArray(s2.sig_value))));
            }
            else
            {
                int SectionID = this.jCbxRegion.getSelectedIndex()-1;
                ComponentID = String.valueOf(SectionID) + "_CorrelationIntensityPlot";
                minX = Utils.findMin(s1.sections.get(SectionID).section_value);
                maxX = Utils.findMax(s1.sections.get(SectionID).section_value);
                minY = Utils.findMin(s2.sections.get(SectionID).section_value);
                maxY = Utils.findMax(s2.sections.get(SectionID).section_value);
                
                IntensityCorrelationPlot.AddPlot(this.exp, Utils.convertDoubleArrayListToArray(s1.sections.get(SectionID).section_value), 
                        Utils.convertDoubleArrayListToArray(s2.sections.get(SectionID).section_value), 
                        ComponentID, minX, minY, maxX, maxY, s1.sections.get(SectionID).section_Name + " Intensity", 
                        s2.sections.get(SectionID).section_Name + " Intensity", false, 
                        true,PlotPoints.plotType.CorrelationIntensityPlot); 
                
                this.jLblCor.setText(String.valueOf(Utils.getCorrelation(Utils.convertDoubleArrayListToArray(s1.sections.get(SectionID).section_value), 
                        Utils.convertDoubleArrayListToArray(s2.sections.get(SectionID).section_value))));
                
            }                                   
            jPnlPlot.setLayout(new BorderLayout());
            jPnlPlot.removeAll();
            jPnlPlot.repaint();
            jPnlPlot.add(IntensityCorrelationPlot.chartPanel,BorderLayout.CENTER);
            jPnlPlot.validate();
            this.jLblSlope.setText(String.valueOf(this.exp.fitSlope));
            this.jLblIntercept.setText(String.valueOf(this.exp.fitIntercept));
            this.jLblRMSE.setText(String.valueOf(this.exp.fitRMSE));           
        }       
    }//GEN-LAST:event_jBtnPlotActionPerformed

    private void jBtnSaveSigCorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnSaveSigCorActionPerformed
        
        FrmSaveDialog frmsave = new FrmSaveDialog(this.exp, Utils.SaveButton.SaveSignalIntensityCorrelation);
        frmsave.setVisible(true);                
    }//GEN-LAST:event_jBtnSaveSigCorActionPerformed

    private void jBtnSaveSecCorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnSaveSecCorActionPerformed
        FrmSaveDialog frmsave = new FrmSaveDialog(this.exp, Utils.SaveButton.SaveSectionIntensityCorrelation);
        frmsave.setVisible(true);
    }//GEN-LAST:event_jBtnSaveSecCorActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnPlot;
    private javax.swing.JButton jBtnSaveSecCor;
    private javax.swing.JButton jBtnSaveSigCor;
    private javax.swing.JComboBox jCbxRegion;
    private javax.swing.JComboBox jCbxSigX;
    private javax.swing.JComboBox jCbxYSig;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLblCor;
    private javax.swing.JLabel jLblIntercept;
    private javax.swing.JLabel jLblRMSE;
    private javax.swing.JLabel jLblSec;
    private javax.swing.JLabel jLblSlope;
    private javax.swing.JLabel jLblXSig;
    private javax.swing.JLabel jLblYSig;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPnlControls;
    private javax.swing.JPanel jPnlPlot;
    // End of variables declaration//GEN-END:variables
}
