/*
 * Copyright (C) 2018 mahsa.moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

/**
 *
 * @author mahsa.moein
 */
public class FrmRatioRemoveBG extends javax.swing.JFrame {

    Experiment exp;
    private final JDialog dialog_ref;
    private int signal_Index = -1;
    private SignalPlot sig_plot;
    private SignalPlot freeDyeSig_Plot;
    
    private ArrayList<SignalTemp> BoundDyeSignals_tmp;
    private ArrayList<SignalTemp> FreeDyeSignals_tmp;
    
    public FrmRatioRemoveBG(Experiment exp, int signal_Index, JDialog dialog) {
        initComponents();
        this.SetLayout();        
        this.dialog_ref = dialog;

        dialog_ref.addWindowListener(new java.awt.event.WindowAdapter() {
            @Override
            public void windowClosing(java.awt.event.WindowEvent windowEvent) {
                if (JOptionPane.YES_OPTION == JOptionPane.showConfirmDialog(dialog_ref,
                        "Do you want to apply your changes to signal before closing?", "",
                        JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE)) {
                    ConfirmClose();
                } else {
                    CancelClose();
                }
            }

        });
        
        dialog_ref.addComponentListener(new ComponentAdapter() {
            @Override
            public void componentResized(ComponentEvent e) {
                windowResized();
            }
        });
        
        for (EnumType.CurveType value : EnumType.CurveType.values()) {
            jCbxCurveTypeBoundDye.addItem(value);
            jCbxCurveTypeFreeDye.addItem(value);
            
        }
        jCbxCurveTypeBoundDye.setSelectedItem(EnumType.CurveType.None);
        jCbxCurveTypeFreeDye.setSelectedItem(EnumType.CurveType.None);
        DisableControls();
                
        if(exp!=null && signal_Index!=-1)
        {
            this.signal_Index = signal_Index;
            this.exp = exp;            
            jPnlSignalPlot.setLayout(new BorderLayout());
            jPnlfreeDye.setLayout(new BorderLayout());
            CopyBoundDyeSignals();
            this.CreateAndShowSignalPlot();            
            this.ShowSignalPlot();
            
            if(this.exp.freeDyeSignals!=null && this.exp.freeDyeSignals.size()>0)
            {
               this.jTxtFilePath.setText(this.exp.freeDyeSignalsFilePath); 
               this.jTxtColumnName.setText(this.exp.freeDyeSignalsColumnName);
               CopyFreeDyeSignals();
               this.CreateAndShowFreeDyeSignal();
               this.ShowFreeDyeSignal();
               EnableControls();
            }
        }        
    }
    
    private void DisableControls()
    {
       this.jLabel3.setEnabled(false);
        jCbxCurveTypeBoundDye.setEnabled(false);
        jLabel4.setEnabled(false);
        jCbxCurveTypeFreeDye.setEnabled(false);
        jCbxSubtract.setEnabled(false);
        jCbxComputeRatio.setEnabled(false);
        jCbxAllSignals.setEnabled(false);
        jBtnReset.setEnabled(false);
        jBtnConfirm.setEnabled(false);
        jBtnCancelClose.setEnabled(false);
        jBtnApply.setEnabled(false); 
    }
    
    private void EnableControls()
    {
        this.jLabel3.setEnabled(true);
        jCbxCurveTypeBoundDye.setEnabled(true);
        jCbxCurveTypeBoundDye.setSelectedIndex(0);
        jLabel4.setEnabled(true);
        jCbxCurveTypeFreeDye.setEnabled(true);
        jCbxCurveTypeFreeDye.setSelectedIndex(0);
        jCbxSubtract.setEnabled(true);
        jCbxComputeRatio.setEnabled(true);
        jCbxAllSignals.setEnabled(true);
        jBtnReset.setEnabled(true);
        jBtnConfirm.setEnabled(true);
        jBtnCancelClose.setEnabled(true);
        jBtnApply.setEnabled(true);
        jCbxSubtract.setSelected(false);
        jCbxComputeRatio.setSelected(false);
        jCbxAllSignals.setSelected(false);
        
    }
    
    private void CopyBoundDyeSignals()
    {        
        this.BoundDyeSignals_tmp = null;
        BoundDyeSignals_tmp = new ArrayList<SignalTemp>();
        for(int i=0; i< this.exp.signals.size(); i++)
        {
            SignalTemp st = new SignalTemp();
            st.sig_Id = this.exp.signals.get(i).getSig_Id();
            st.sig_time = (ArrayList<Double>)this.exp.signals.get(i).sig_time.clone();
            st.sig_value = (ArrayList<Double>)this.exp.signals.get(i).sig_value.clone();
            BoundDyeSignals_tmp.add(st);
        }
        System.gc();     
    }
    
    private void CopyFreeDyeSignals()
    {        
        this.FreeDyeSignals_tmp = null;
        FreeDyeSignals_tmp = new ArrayList<SignalTemp>();
        for(int i=0; i< this.exp.freeDyeSignals.size(); i++)
        {
            SignalTemp st = new SignalTemp();
            st.sig_Id = this.exp.freeDyeSignals.get(i).getSig_Id();
            st.sig_time = (ArrayList<Double>)this.exp.freeDyeSignals.get(i).sig_time.clone();
            st.sig_value = (ArrayList<Double>)this.exp.freeDyeSignals.get(i).sig_value.clone();
            FreeDyeSignals_tmp.add(st);
        }
        System.gc();     
    }
    
    private void windowResized()
    {
        int Height = this.jPnlPlots.getHeight();
        int width = this.jPnlPlots.getWidth();

        int HPlot = (int) Math.floor(0.5 * Height);        
        this.jPnlSignalPlot.setPreferredSize(new Dimension(width, HPlot));
        this.jPnlfreeDye.setPreferredSize(new Dimension(width, HPlot));
    }
    
    private void CreateAndShowSignalPlot()
    {
        this.sig_plot = null;
        this.sig_plot = exp.signals.get(signal_Index).createSignalPlotWithoutPeaksAndSections(this.exp);
        this.ShowSignalPlot();
    }
    
    private void ShowSignalPlot() {
        if(sig_plot!= null)
        {
            jPnlSignalPlot.removeAll(); 
            jPnlSignalPlot.repaint();
            jPnlSignalPlot.add(this.sig_plot.Signalcpanel);            
            jPnlSignalPlot.validate();            
        }
        else
        {
             JOptionPane.showMessageDialog(this, "Signal cannot be shown!");
        }                
    }
    
    private void CreateAndShowFreeDyeSignal(){
        
        this.freeDyeSig_Plot = null;
        this.freeDyeSig_Plot = this.exp.freeDyeSignals.get(signal_Index).createSignalPlotWithoutPeaksAndSections(exp);
        this.ShowFreeDyeSignal();
    }
    
    private void ShowFreeDyeSignal()
    {
        if(freeDyeSig_Plot!= null)
        {
            jPnlfreeDye.removeAll(); 
            jPnlfreeDye.repaint();
            jPnlfreeDye.add(this.freeDyeSig_Plot.Signalcpanel);            
            jPnlfreeDye.validate();
            
        }
        else
        {
             JOptionPane.showMessageDialog(this, "Signal is not found!");
        }
    }
                
    private void CancelClose()
    {
       this.Reset(true);
       this.dialog_ref.dispose();
       
    }
    
    private void ConfirmClose()
    {
        if(!jCbxAllSignals.isSelected())
        {           
           Signal BoundDyeSig = exp.signals.get(signal_Index);
           Signal FreeDyeSig = exp.freeDyeSignals.get(signal_Index);
           if(BoundDyeSig.IsBackgroundRemoved_temp || BoundDyeSig.IsNormalized_temp)
           {
               BoundDyeSig.EditSectionValuesByChangingSignalValues(); 
           }
           
        }
        else
        {
           for(Signal sig:exp.signals)
           {
               if(sig.IsBackgroundRemoved_temp || sig.IsNormalized_temp)
               {
                   sig.EditSectionValuesByChangingSignalValues(); 
               }
           }
        }
        this.dialog_ref.dispose();
    }

    
    private void SetLayout() 
    {
        this.setLayout(new BorderLayout());
        this.jPnlTop.setPreferredSize(new Dimension(985,55));
        this.add(this.jPnlTop, BorderLayout.NORTH);        
        jPnlControls.setPreferredSize(new Dimension(351,532));
        this.add(this.jPnlControls, BorderLayout.WEST);
        
        this.jPnlPlots.setLayout(new BorderLayout());
        this.jPnlPlots.setPreferredSize(new Dimension(633,533));
        this.add(this.jPnlPlots, BorderLayout.CENTER);
        
        this.jPnlSignalPlot.setLayout(new BorderLayout());
        this.jPnlSignalPlot.setPreferredSize(new Dimension(625,261));
        this.jPnlPlots.add(this.jPnlSignalPlot,BorderLayout.NORTH);
        
        this.jPnlfreeDye.setLayout(new BorderLayout());
        this.jPnlfreeDye.setPreferredSize(new Dimension(625,261));
        this.jPnlPlots.add(this.jPnlfreeDye,BorderLayout.CENTER);
        this.pack();
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPnlTop = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTxtFilePath = new javax.swing.JTextField();
        jBtnBrowse = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        jTxtColumnName = new javax.swing.JTextField();
        jBtnOpen = new javax.swing.JButton();
        jPnlPlots = new javax.swing.JPanel();
        jPnlSignalPlot = new javax.swing.JPanel();
        jPnlfreeDye = new javax.swing.JPanel();
        jPnlControls = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jCbxCurveTypeBoundDye = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        jCbxCurveTypeFreeDye = new javax.swing.JComboBox();
        jCbxSubtract = new javax.swing.JCheckBox();
        jCbxComputeRatio = new javax.swing.JCheckBox();
        jCbxAllSignals = new javax.swing.JCheckBox();
        jBtnConfirm = new javax.swing.JButton();
        jBtnCancelClose = new javax.swing.JButton();
        jBtnReset = new javax.swing.JButton();
        jBtnApply = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Remove background in ration-metric dyes");
        setBounds(new java.awt.Rectangle(0, 23, 1000, 0));
        setPreferredSize(new java.awt.Dimension(1000, 642));

        jPnlTop.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlTop.setPreferredSize(new java.awt.Dimension(985, 55));
        jPnlTop.setSize(new java.awt.Dimension(985, 55));

        jLabel1.setText("Free dye signal file:");

        jTxtFilePath.setToolTipText("");
        jTxtFilePath.setPreferredSize(new java.awt.Dimension(300, 26));
        jTxtFilePath.setSize(new java.awt.Dimension(300, 26));

        jBtnBrowse.setText("Browse");
        jBtnBrowse.setPreferredSize(new java.awt.Dimension(100, 29));
        jBtnBrowse.setSize(new java.awt.Dimension(100, 29));
        jBtnBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnBrowseActionPerformed(evt);
            }
        });

        jLabel2.setText("Column name contains:");

        jTxtColumnName.setToolTipText("");
        jTxtColumnName.setPreferredSize(new java.awt.Dimension(100, 26));
        jTxtColumnName.setSize(new java.awt.Dimension(100, 26));

        jBtnOpen.setText("Open");
        jBtnOpen.setPreferredSize(new java.awt.Dimension(100, 29));
        jBtnOpen.setSize(new java.awt.Dimension(100, 29));
        jBtnOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnOpenActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPnlTopLayout = new javax.swing.GroupLayout(jPnlTop);
        jPnlTop.setLayout(jPnlTopLayout);
        jPnlTopLayout.setHorizontalGroup(
            jPnlTopLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlTopLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTxtFilePath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnBrowse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTxtColumnName, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBtnOpen, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(11, Short.MAX_VALUE))
        );
        jPnlTopLayout.setVerticalGroup(
            jPnlTopLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlTopLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlTopLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel1)
                    .addComponent(jTxtFilePath, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnBrowse, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jTxtColumnName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnOpen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(16, Short.MAX_VALUE))
        );

        jTxtFilePath.getAccessibleContext().setAccessibleName("");

        jPnlPlots.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlPlots.setPreferredSize(new java.awt.Dimension(633, 533));
        jPnlPlots.setSize(new java.awt.Dimension(633, 533));

        jPnlSignalPlot.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnlSignalPlot.setPreferredSize(new java.awt.Dimension(625, 261));
        jPnlSignalPlot.setSize(new java.awt.Dimension(625, 261));

        javax.swing.GroupLayout jPnlSignalPlotLayout = new javax.swing.GroupLayout(jPnlSignalPlot);
        jPnlSignalPlot.setLayout(jPnlSignalPlotLayout);
        jPnlSignalPlotLayout.setHorizontalGroup(
            jPnlSignalPlotLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 623, Short.MAX_VALUE)
        );
        jPnlSignalPlotLayout.setVerticalGroup(
            jPnlSignalPlotLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 259, Short.MAX_VALUE)
        );

        jPnlfreeDye.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPnlfreeDye.setPreferredSize(new java.awt.Dimension(625, 261));
        jPnlfreeDye.setSize(new java.awt.Dimension(625, 261));

        javax.swing.GroupLayout jPnlfreeDyeLayout = new javax.swing.GroupLayout(jPnlfreeDye);
        jPnlfreeDye.setLayout(jPnlfreeDyeLayout);
        jPnlfreeDyeLayout.setHorizontalGroup(
            jPnlfreeDyeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 623, Short.MAX_VALUE)
        );
        jPnlfreeDyeLayout.setVerticalGroup(
            jPnlfreeDyeLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 259, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPnlPlotsLayout = new javax.swing.GroupLayout(jPnlPlots);
        jPnlPlots.setLayout(jPnlPlotsLayout);
        jPnlPlotsLayout.setHorizontalGroup(
            jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlPlotsLayout.createSequentialGroup()
                .addGap(2, 2, 2)
                .addGroup(jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPnlfreeDye, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPnlSignalPlot, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jPnlPlotsLayout.setVerticalGroup(
            jPnlPlotsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlPlotsLayout.createSequentialGroup()
                .addComponent(jPnlSignalPlot, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(2, 2, 2)
                .addComponent(jPnlfreeDye, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jPnlControls.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPnlControls.setPreferredSize(new java.awt.Dimension(351, 532));
        jPnlControls.setSize(new java.awt.Dimension(351, 532));

        jLabel3.setText("Curve type for bound dye:");

        jCbxCurveTypeBoundDye.setPreferredSize(new java.awt.Dimension(160, 27));
        jCbxCurveTypeBoundDye.setSize(new java.awt.Dimension(160, 27));
        jCbxCurveTypeBoundDye.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCbxCurveTypeBoundDyeItemStateChanged(evt);
            }
        });

        jLabel4.setText("Curve type for free dye:");

        jCbxCurveTypeFreeDye.setPreferredSize(new java.awt.Dimension(160, 27));
        jCbxCurveTypeFreeDye.setSize(new java.awt.Dimension(160, 27));
        jCbxCurveTypeFreeDye.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                jCbxCurveTypeFreeDyeItemStateChanged(evt);
            }
        });

        jCbxSubtract.setText("Subtract background");
        jCbxSubtract.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCbxSubtractStateChanged(evt);
            }
        });

        jCbxComputeRatio.setText("Compute ratio");

        jCbxAllSignals.setText("Apply to all signals");

        jBtnConfirm.setText("Confirm & Close");
        jBtnConfirm.setPreferredSize(new java.awt.Dimension(150, 29));
        jBtnConfirm.setSize(new java.awt.Dimension(150, 29));
        jBtnConfirm.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnConfirmActionPerformed(evt);
            }
        });

        jBtnCancelClose.setText("Cancel & Close");
        jBtnCancelClose.setPreferredSize(new java.awt.Dimension(150, 29));
        jBtnCancelClose.setSize(new java.awt.Dimension(150, 29));
        jBtnCancelClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnCancelCloseActionPerformed(evt);
            }
        });

        jBtnReset.setText("Reset");
        jBtnReset.setPreferredSize(new java.awt.Dimension(150, 29));
        jBtnReset.setSize(new java.awt.Dimension(150, 29));
        jBtnReset.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnResetActionPerformed(evt);
            }
        });

        jBtnApply.setText("Apply");
        jBtnApply.setPreferredSize(new java.awt.Dimension(150, 29));
        jBtnApply.setSize(new java.awt.Dimension(150, 29));
        jBtnApply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jBtnApplyActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPnlControlsLayout = new javax.swing.GroupLayout(jPnlControls);
        jPnlControls.setLayout(jPnlControlsLayout);
        jPnlControlsLayout.setHorizontalGroup(
            jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(jLabel4)
                    .addComponent(jCbxSubtract)
                    .addComponent(jCbxComputeRatio)
                    .addComponent(jCbxAllSignals)
                    .addComponent(jBtnConfirm, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnApply, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jBtnReset, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCbxCurveTypeBoundDye, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jCbxCurveTypeFreeDye, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnCancelClose, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        jPnlControlsLayout.setVerticalGroup(
            jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPnlControlsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jCbxCurveTypeBoundDye, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jCbxCurveTypeFreeDye, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(jCbxSubtract)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jCbxComputeRatio)
                .addGap(12, 12, 12)
                .addComponent(jCbxAllSignals)
                .addGap(16, 16, 16)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnReset, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnApply, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPnlControlsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBtnConfirm, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jBtnCancelClose, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(265, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(2, 2, 2)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPnlTop, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPnlControls, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(2, 2, 2)
                        .addComponent(jPnlPlots, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(1, 1, 1))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPnlTop, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(2, 2, 2)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPnlPlots, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPnlControls, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBtnBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnBrowseActionPerformed
        // TODO add your handling code here:
        javax.swing.JFileChooser fc = new JFileChooser();
        if (Utils.SaveAndBrowseDefaultPath != null) {
            fc.setCurrentDirectory(Utils.SaveAndBrowseDefaultPath);
        }       
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            String filePath ="";
            if(file.isDirectory())
            {
                JOptionPane.showMessageDialog(this, "Please select a file.");
                return;
            }
            else
            {
               filePath = file.getAbsolutePath();
               Utils.SaveAndBrowseDefaultPath = file;
            }
            if (!Utils.CheckFileExtension(file)) {
                JOptionPane.showMessageDialog(this, "Please select a file with readble extension."
                );
                jTxtFilePath.setText("");

            } else {
                jTxtFilePath.setText(filePath);
            }
        }
        fc = null;
    }//GEN-LAST:event_jBtnBrowseActionPerformed

    public boolean ReadFreeDyeSignals(String fileName, String ColumnName) throws InvalidFormatException, IOException
    {
        boolean fileIsRead = false;
        this.exp.freeDyeSignals = null;
        this.exp.freeDyeSignals = new ArrayList<>();        
        Utils.ReadFileStatus ReadStatus = Utils.ReadFileStatus.FileIsReadCorrectly;            
        String extension = Utils.getExtension(fileName);      
        if ((extension.equals(Utils.xls))) {
           Utils.ReadOneExcelFileSignal(fileName, this.exp.freeDyeSignals, ColumnName);
        }
        else{
            if ((extension.equals(Utils.cvs) || (extension.equals(Utils.txt)) || 
                    (extension.equals(Utils.dat)) || (extension.equals(Utils.csv)))) {

               ReadStatus = Utils.CheckFileValidity(fileName);
               if(ReadStatus != Utils.ReadFileStatus.NotEqualColumns)
               {
                    Utils.ReadOneTextFileSignal(fileName,  this.exp.freeDyeSignals, ColumnName);
               }
               else
               {
                   JOptionPane.showMessageDialog(this, "Number of colimns in header is not equal to number of columns in second row.");
                   return fileIsRead;
               }
            }
            else
            {
                JOptionPane.showMessageDialog(this, "Selected file is not readable.");
                return fileIsRead;
            }
        }               
        if( this.exp.freeDyeSignals.isEmpty())
        {
            this.exp.freeDyeSignals = null;
            JOptionPane.showMessageDialog(this, "File cannot be read.");
            
        }
        else 
        {                                
            if(this.exp.freeDyeSignals.size() != this.exp.signals.size())
            {
                this.exp.freeDyeSignals = null;
                JOptionPane.showMessageDialog(this, "Number of free dye signals is not equal to number of bound dye signals!"); 
                return fileIsRead;
            }
            else
            {
                int j =0;
                while(j < this.exp.freeDyeSignals.size())
                {
                    for (Signal signal : this.exp.signals) {
                        if (signal.getSig_Id() == this.exp.freeDyeSignals.get(j).getSig_Id()) {
                            this.exp.freeDyeSignals.get(j).Origin_sig_time.addAll(signal.Origin_sig_time);
                            this.exp.freeDyeSignals.get(j).CopyInitialSignal();
                            this.exp.freeDyeSignals.get(j).AddOneSection();
                            break;
                        }
                    }
                    j++;
                }
                fileIsRead = true;
            }                       
        }
        return fileIsRead;
    }
    
    private void jBtnOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnOpenActionPerformed
        // TODO add your handling code here:
        if ("".equals(jTxtFilePath.getText()) || "".equals(jTxtColumnName.getText())) {
            JOptionPane.showMessageDialog(this, "Please fill the fields correctly");
            return;
        }
        if (this.exp.signals != null && this.exp.signals.size() > 0) {
            try {
                if (ReadFreeDyeSignals(jTxtFilePath.getText().trim(), jTxtColumnName.getText().trim())) {
                    if (this.exp.freeDyeSignals.size() > 0 && signal_Index < this.exp.freeDyeSignals.size()
                            && this.exp.freeDyeSignals.get(signal_Index) != null) {
                        this.exp.freeDyeSignalsFilePath = jTxtFilePath.getText().trim();
                        this.exp.freeDyeSignalsColumnName = jTxtColumnName.getText().trim();
                        CreateAndShowFreeDyeSignal();
                        CopyFreeDyeSignals();
                        for (Signal freeDyeSignal : this.exp.freeDyeSignals) {
                            freeDyeSignal.findPeaks(30,0.2);
                        }
                        this.EnableControls();
                        jTxtFilePath.setEnabled(false);
                        jTxtColumnName.setEnabled(false);
                        jBtnBrowse.setEnabled(false);
                        jBtnOpen.setEnabled(false);
                    }
                }
            } catch (InvalidFormatException ex) {
                Logger.getLogger(FrmRatioRemoveBG.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(FrmRatioRemoveBG.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_jBtnOpenActionPerformed
    
    private void EstimateBaseLineForBoundSignal()
    {                
        EnumType.CurveType selected_curve_type = (EnumType.CurveType)jCbxCurveTypeBoundDye.getSelectedItem();
        
        if(selected_curve_type!= EnumType.CurveType.None)
        {
            Signal sig = exp.signals.get(signal_Index); 
            switch(selected_curve_type)
            {
                case ConstantBaseLine:
                {
                    sig.ConstantBaseLine(this.sig_plot);
                    break;
                }
                case SpikeLine:
                {
                    sig.FitSpikeBaseLine(this.sig_plot);
                    break;
                }
                default:
                {
                    sig.FitCurve(selected_curve_type, sig_plot);
                    break;
                }
            }            
        }
    }
    
    private void EstimateBaseLineForFreeSignal()
    {                
        EnumType.CurveType selected_curve_type = (EnumType.CurveType)jCbxCurveTypeFreeDye.getSelectedItem();
        
        if(selected_curve_type!= EnumType.CurveType.None)
        {
            Signal FreeDye_sig = exp.freeDyeSignals.get(signal_Index); 
            switch(selected_curve_type)
            {
                case ConstantBaseLine:
                {
                    FreeDye_sig.ConstantBaseLine(this.freeDyeSig_Plot);
                    break;
                }
                case SpikeLine:
                {
                    FreeDye_sig.FitSpikeBaseLine(this.freeDyeSig_Plot);
                    break;
                }
                default:
                {
                    FreeDye_sig.FitCurve(selected_curve_type,freeDyeSig_Plot);
                    break;
                }
            }            
        }
    }
    
    private void jCbxCurveTypeBoundDyeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCbxCurveTypeBoundDyeItemStateChanged
        if(evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
        {
            if (jCbxCurveTypeBoundDye.getItemCount() > 0 && this.signal_Index > -1) {
                if((EnumType.CurveType)jCbxCurveTypeBoundDye.getSelectedItem() == EnumType.CurveType.None)
                {
                   CreateAndShowSignalPlot(); 
                }
                else
                {                
                    EstimateBaseLineForBoundSignal();
                    this.ShowSignalPlot(); 
                }
            }
        }
    }//GEN-LAST:event_jCbxCurveTypeBoundDyeItemStateChanged

    private void jCbxCurveTypeFreeDyeItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_jCbxCurveTypeFreeDyeItemStateChanged

        if(evt.getStateChange() == java.awt.event.ItemEvent.SELECTED)
        {
            if (jCbxCurveTypeFreeDye.getItemCount() > 0 && this.signal_Index > -1) {
                if((EnumType.CurveType)jCbxCurveTypeFreeDye.getSelectedItem() == EnumType.CurveType.None)
                {
                   CreateAndShowFreeDyeSignal(); 
                }
                else
                {                
                    EstimateBaseLineForFreeSignal();
                    this.ShowFreeDyeSignal(); 
                }
            }
        }
    }//GEN-LAST:event_jCbxCurveTypeFreeDyeItemStateChanged

    private void jCbxSubtractStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCbxSubtractStateChanged
        // TODO add your handling code here:
        
    }//GEN-LAST:event_jCbxSubtractStateChanged
    
    private void Reset(boolean allSignals)
    {       
        if(allSignals)
        {
            for(int i=0; i< exp.signals.size(); i++)
            {
                SignalTemp sig_temp = BoundDyeSignals_tmp.get(i);
                Signal sig = exp.signals.get(i);
                
                SignalTemp Free_sig_temp = FreeDyeSignals_tmp.get(i);
                Signal Freesig = exp.freeDyeSignals.get(i);
                
                if(((sig.IsBackgroundRemoved_temp || sig.IsNormalized_temp)&& !sig.SigBGRemoved && !sig.IsNormalized) ||                   
                    (Freesig.IsBackgroundRemoved_temp && !Freesig.SigBGRemoved))
                {
                    for(int j=0; j< sig.sig_time.size(); j++ )
                    {
                        sig.sig_value.set(j, sig_temp.sig_value.get(j));
                        Freesig.sig_value.set(j, Free_sig_temp.sig_value.get(j));
                    }
                    sig.resetBackgroundFlags();
                    Freesig.resetBackgroundFlags();
                    EnableControls();
                }               
            }
        }
        else
        {
            SignalTemp sig_temp = BoundDyeSignals_tmp.get(signal_Index);
            Signal sig = exp.signals.get(signal_Index);
            SignalTemp Free_sig_temp = FreeDyeSignals_tmp.get(signal_Index);
            Signal Freesig = exp.freeDyeSignals.get(signal_Index);

            if (((sig.IsBackgroundRemoved_temp || sig.IsNormalized_temp) && !sig.SigBGRemoved && !sig.IsNormalized)
                    || (Freesig.IsBackgroundRemoved_temp && !Freesig.SigBGRemoved)) {
                for (int j = 0; j < sig.sig_time.size(); j++) {
                    sig.sig_value.set(j, sig_temp.sig_value.get(j));
                    Freesig.sig_value.set(j, Free_sig_temp.sig_value.get(j));
                }
                sig.resetBackgroundFlags();
                Freesig.resetBackgroundFlags();
                EnableControls();
            }
        }              
    }
    
    private void jBtnApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnApplyActionPerformed
        
        
        boolean IsBGRemoved = false;
        boolean IsNormalized = false;        
        if(!jCbxAllSignals.isSelected())
        {
            Signal BoundDyeSig = exp.signals.get(signal_Index);
            Signal freeDyeSig = exp.freeDyeSignals.get(signal_Index);
            
            if(jCbxSubtract.isSelected() &&  !BoundDyeSig.IsNormalized_temp && !BoundDyeSig.SigBGRemoved && !BoundDyeSig.IsBackgroundRemoved_temp &&
                !freeDyeSig.SigBGRemoved && !freeDyeSig.IsBackgroundRemoved_temp) 
            {
                if(BoundDyeSig.subtractBackgrund() && freeDyeSig.subtractBackgrund())
                {                    
//                    if(freeDyeSig.CheckZeroValueInSignal())
//                    {
//                        JOptionPane.showMessageDialog(this, "Removing Background There is zero values in Free dye signal. Therefore computing ratio "
//                        + "is not possibe. Please fit another curve to the baseline.");
//                        this.Reset(false);
//                        return;
//                    }
//                    else
//                    {                    
                        //jCbxSubtractBG.setSelected(false);
                        jCbxSubtract.setEnabled(false);
                        IsBGRemoved = true;
                    //}
                    
                }
            }
            
            if(jCbxComputeRatio.isSelected() && !BoundDyeSig.IsNormalized && !BoundDyeSig.IsNormalized_temp)
            {
                if(BoundDyeSig.ComputeRatioBoundToFreeDye(freeDyeSig))
                {
                    IsNormalized = true;                    
                }
                else
                {
                    JOptionPane.showMessageDialog(this, "There is zero values in Free dye signal. Therefore computing ratio "
                        + "is not possibe.");
                    return;
                }
               
            }
            
        }
        else
        {
            EnumType.CurveType selected_curve_BoundDye = (EnumType.CurveType)jCbxCurveTypeBoundDye.getSelectedItem();
            EnumType.CurveType selected_curve_FreeDye = (EnumType.CurveType)jCbxCurveTypeFreeDye.getSelectedItem();        
            for (int i = 0; i < this.exp.signals.size(); i++) {
                Signal BoundDyeSig = exp.signals.get(i);
                Signal freeDyeSig = exp.freeDyeSignals.get(i);

                if (jCbxSubtract.isSelected() && !BoundDyeSig.IsNormalized_temp && !BoundDyeSig.SigBGRemoved && !BoundDyeSig.IsBackgroundRemoved_temp
                        && !freeDyeSig.SigBGRemoved && !freeDyeSig.IsBackgroundRemoved_temp) {                    
                    if (BoundDyeSig.IsPeakComputedForAllSections() && selected_curve_BoundDye != EnumType.CurveType.None
                            && selected_curve_FreeDye != EnumType.CurveType.None) {
                        
                        if (BoundDyeSig.ComputeRegressionParams(selected_curve_BoundDye, this.sig_plot) && 
                                freeDyeSig.ComputeRegressionParams(selected_curve_FreeDye, this.freeDyeSig_Plot)) {
                                
                            if(BoundDyeSig.subtractBackgrund() && freeDyeSig.subtractBackgrund())
                            {                    
//                                if(freeDyeSig.CheckZeroValueInSignal())
//                                {
//                                    this.Reset(true);
//                                    return;
//                                }
//                                else
//                                {                    
                                    IsBGRemoved = true;
                                    jCbxAllSignals.setEnabled(false);
                                //}
                            }
                        }
                    }
                }
                if(jCbxComputeRatio.isSelected() && !BoundDyeSig.IsNormalized && !BoundDyeSig.IsNormalized_temp)
                {
                    if(BoundDyeSig.ComputeRatioBoundToFreeDye(freeDyeSig))
                    {
                        IsNormalized = true; 
                        jCbxAllSignals.setEnabled(false);
                    }
                }
            }            
        }
        if(IsBGRemoved){
           jCbxCurveTypeBoundDye.setEnabled(false);
           jCbxCurveTypeFreeDye.setEnabled(false);
           jCbxSubtract.setEnabled(false); 
           //jCbxSubtract.setSelected(false);
        }
        if(IsNormalized)
        {
           jCbxCurveTypeBoundDye.setEnabled(false);
           jCbxCurveTypeFreeDye.setEnabled(false);
           jCbxSubtract.setEnabled(false); 
           jCbxSubtract.setSelected(false);
           jCbxComputeRatio.setEnabled(false);
           //jCbxComputeRatio.setSelected(false);
        }
        
        if(IsBGRemoved || IsNormalized)
        {
            this.CreateAndShowSignalPlot();
            this.CreateAndShowFreeDyeSignal();          
        }
        
        
    }//GEN-LAST:event_jBtnApplyActionPerformed

    private void jBtnResetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnResetActionPerformed
        // TODO add your handling code here:
        this.Reset(jCbxAllSignals.isSelected());
        EnableControls();
        this.CreateAndShowSignalPlot();
        this.CreateAndShowFreeDyeSignal();
    }//GEN-LAST:event_jBtnResetActionPerformed

    private void jBtnConfirmActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnConfirmActionPerformed
        // TODO add your handling code here:        
        ConfirmClose();
    }//GEN-LAST:event_jBtnConfirmActionPerformed

    private void jBtnCancelCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jBtnCancelCloseActionPerformed
            // TODO add your handling code here:
        this.CancelClose();
    }//GEN-LAST:event_jBtnCancelCloseActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBtnApply;
    private javax.swing.JButton jBtnBrowse;
    private javax.swing.JButton jBtnCancelClose;
    private javax.swing.JButton jBtnConfirm;
    private javax.swing.JButton jBtnOpen;
    private javax.swing.JButton jBtnReset;
    private javax.swing.JCheckBox jCbxAllSignals;
    private javax.swing.JCheckBox jCbxComputeRatio;
    private javax.swing.JComboBox jCbxCurveTypeBoundDye;
    private javax.swing.JComboBox jCbxCurveTypeFreeDye;
    private javax.swing.JCheckBox jCbxSubtract;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPnlControls;
    private javax.swing.JPanel jPnlPlots;
    private javax.swing.JPanel jPnlSignalPlot;
    private javax.swing.JPanel jPnlTop;
    private javax.swing.JPanel jPnlfreeDye;
    private javax.swing.JTextField jTxtColumnName;
    private javax.swing.JTextField jTxtFilePath;
    // End of variables declaration//GEN-END:variables
}
