/*
 * Copyright (C) 2017 mahsa.moein
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package CaSiAn;

import java.util.ArrayList;

/**
 *
 * @author mahsa.moein
 */
public class MatCasa {
    
    Experiment exp;
    
    public double[][] createSignalsGetFeatures(double [][] signals, float timeBetSamples,int peakThereshold)
    {
       this.exp = new Experiment(timeBetSamples);
       
       int row = signals.length;
       int column = signals[0].length;
       double[][] SignalFeatures = new double[row][20];
       
       for (int i=0 ; i< row; i++)
       {
           double[] OneSignal = new double[column];           
           System.arraycopy(signals[i], 0, OneSignal, 0, column);           
           Signal sig = createSignalObject(OneSignal,i,timeBetSamples);           
           this.exp.signals.add(sig);
           this.exp.findPeaks(peakThereshold,0.2);
                    
            Sections sec = sig.sections.get(0);
            if(sec != null && sec.TimeIsAddedToSection && sec.IsPeakFound)                   
            {                    
                SignalFeatures[i][0] = sig.getSig_Id();
                SignalFeatures[i][1] = sec.getPeakNumber();
                SignalFeatures[i][2] = sec.getIntensitiesMean();
                SignalFeatures[i][3] = sec.getIntensitiesSD();
                SignalFeatures[i][4] = sec.getSNR();
                SignalFeatures[i][5] = sec.getTav();
                SignalFeatures[i][6] = sec.getSTD();
                SignalFeatures[i][7] = sec.getFreqSNR();
                SignalFeatures[i][8] = sec.getMeanSW();                                  
                SignalFeatures[i][9] = sec.getSpikeWidthSD();
                SignalFeatures[i][10] = sec.getMeanAMP();
                SignalFeatures[i][11] = sec.getAmplitudeSD();
                SignalFeatures[i][12] = sec.getRootMeanSquareSection();     
                SignalFeatures[i][13] = sec.getSpikeAreaAverage();    
                SignalFeatures[i][14] = sec.getSpikeAreaSD();                                                                 
                SignalFeatures[i][15] = sec.getTimeToPeakAverage();
                SignalFeatures[i][16] = sec.getAverageReleasingRate();
                SignalFeatures[i][17] = sec.getAverageRemovingRate();
                SignalFeatures[i][18] = sec.getMeanPeakValue();
                SignalFeatures[i][19] = sec.getMeanNadirValue();
            }                                   
        }       
       return SignalFeatures;
    }
    
    public double[][] getSignalProfile()
    {              
        double[][] SpikeFeatures = null;
        if (this.exp != null && this.exp.signals != null) {
            int numberofRows = 0;
            for (Signal sig : this.exp.signals) {
                Sections sec = sig.sections.get(0);
                if (sec != null && sec.IsPeakFound) {
                    for (int k = 0; k < sec.getPeakNumber(); k++) {
                        numberofRows++;
                    }
                }
            }
            SpikeFeatures = new double[numberofRows][14];
            int i = 0;
            for (Signal sig : this.exp.signals) {
                Sections sec = sig.sections.get(0);

                if (sec != null && sec.IsPeakFound) {
                    sec.computeISI();
                    for (int k = 0; k < sec.getPeakNumber(); k++) //k move over the peaks which are in the current section
                    {
                        SpikeFeatures[i][0] = sig.getSig_Id();
                        SpikeFeatures[i][1] = k + 1;
                        SpikeFeatures[i][2] = sec.getPeakIndex_Max(k);
                        SpikeFeatures[i][3] = sec.getPeakIndex_Min(k);
                        SpikeFeatures[i][4] = sec.getMaxPeakValue(k);
                        SpikeFeatures[i][5] = sec.getMinPeakValue(k);
                        SpikeFeatures[i][6] = sec.getSpikeWidth(k);
                        SpikeFeatures[i][7] = sec.getAmplitude(k);
                        SpikeFeatures[i][8] = sec.getPeakTimeForOnePeak(k); // ISI time
                        SpikeFeatures[i][9] = sec.getISI(k);
                        SpikeFeatures[i][10] = sec.getEffectiveSpikeArea(k);
                        SpikeFeatures[i][11] = sec.getTimeToPeak(k);
                        SpikeFeatures[i][12] = sec.getReleasingRate(k);
                        SpikeFeatures[i][13] = sec.getRemovingRate(k);
                        i++;
                    }
                }
            }

        }
        return SpikeFeatures;
    }
    
    private Signal createSignalObject(double[] signal, int rowNo, float timeBetSamples)
    {
        Signal sig = new Signal(rowNo, rowNo, "Signal" + String.valueOf(rowNo));
        
        int time = 1;
        
        for(int i=0; i< signal.length; i++)
        {
            sig.Origin_sig_value.add(signal[i]);
            if(time == 1)
                sig.Origin_sig_time.add(Double.parseDouble(String.valueOf(time)));
            else
                sig.Origin_sig_time.add(Double.parseDouble(String.valueOf(time))*timeBetSamples);
            
            time++;
        }
        sig.CopyInitialSignal();
        sig.AddOneSection();  
        this.exp.NumberOfSections = 1;
        return sig;       
    }
    
  
    
    
}
