--
-- Type: TABLE; Owner: BIOMART; Name: BIO_ASSAY_ANALYSIS_DATA_TEA
--
 CREATE TABLE "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" 
  (	"BIO_ASY_ANALYSIS_DATA_ID" NUMBER NOT NULL ENABLE, 
"FOLD_CHANGE_RATIO" NUMBER, 
"R_VALUE" NUMBER(18,5), 
"RHO_VALUE" NUMBER(18,5), 
"BIO_ASSAY_ANALYSIS_ID" NUMBER(18,0) NOT NULL ENABLE, 
"ADJUSTED_P_VALUE_CODE" NVARCHAR2(100), 
"FEATURE_GROUP_NAME" VARCHAR2(100 BYTE) NOT NULL ENABLE, 
"BIO_EXPERIMENT_ID" NUMBER(18,0), 
"BIO_ASSAY_PLATFORM_ID" NUMBER(18,0), 
"ETL_ID" NVARCHAR2(100), 
"CUT_VALUE" NUMBER(18,5), 
"RESULTS_VALUE" NVARCHAR2(100), 
"NUMERIC_VALUE" NUMBER(18,5), 
"NUMERIC_VALUE_CODE" NVARCHAR2(50), 
"TEA_NORMALIZED_PVALUE" NUMBER(18,5), 
"BIO_EXPERIMENT_TYPE" VARCHAR2(50 BYTE), 
"BIO_ASSAY_FEATURE_GROUP_ID" NUMBER(18,0), 
"TEA_RANK" NUMBER(18,0), 
"RAW_PVALUE" BINARY_DOUBLE, 
"ADJUSTED_PVALUE" BINARY_DOUBLE, 
"PREFERRED_PVALUE" BINARY_DOUBLE, 
"PROBESET_ID" NUMBER(22,0), 
 CONSTRAINT "BIO_AA_DATA_T_PK" PRIMARY KEY ("BIO_ASY_ANALYSIS_DATA_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_EXP_ANALYSIS1
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_EXP_ANALYSIS1" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_EXPERIMENT_ID", "BIO_ASSAY_ANALYSIS_ID", "BIO_ASY_ANALYSIS_DATA_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_PROBE_ID
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_PROBE_ID" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_ASSAY_FEATURE_GROUP_ID", "BIO_ASY_ANALYSIS_DATA_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_ASSAY_ANALYSIS_DATA_T_FK1
--
ALTER TABLE "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ADD CONSTRAINT "BIO_ASSAY_ANALYSIS_DATA_T_FK1" FOREIGN KEY ("BIO_ASSAY_ANALYSIS_ID")
 REFERENCES "BIOMART"."BIO_ASSAY_ANALYSIS" ("BIO_ASSAY_ANALYSIS_ID") ENABLE;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_ASSAY_ANALYSIS_DATA_T_FK2
--
ALTER TABLE "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ADD CONSTRAINT "BIO_ASSAY_ANALYSIS_DATA_T_FK2" FOREIGN KEY ("BIO_EXPERIMENT_ID")
 REFERENCES "BIOMART"."BIO_EXPERIMENT" ("BIO_EXPERIMENT_ID") DISABLE;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_ASSAY_ANALYSIS_DATA_T_FK3
--
ALTER TABLE "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ADD CONSTRAINT "BIO_ASSAY_ANALYSIS_DATA_T_FK3" FOREIGN KEY ("BIO_ASSAY_PLATFORM_ID")
 REFERENCES "BIOMART"."BIO_ASSAY_PLATFORM" ("BIO_ASSAY_PLATFORM_ID") DISABLE;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_PROBE_NAME
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_PROBE_NAME" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("FEATURE_GROUP_NAME", "BIO_ASY_ANALYSIS_DATA_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_PROBE_ANALYSIS
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_PROBE_ANALYSIS" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_ASSAY_FEATURE_GROUP_ID", "BIO_ASSAY_ANALYSIS_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_EXP_ANALYSIS
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_EXP_ANALYSIS" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_EXPERIMENT_ID", "BIO_ASSAY_ANALYSIS_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_ASY_AD_TEA_FG_FK
--
ALTER TABLE "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ADD CONSTRAINT "BIO_ASY_AD_TEA_FG_FK" FOREIGN KEY ("BIO_ASSAY_FEATURE_GROUP_ID")
 REFERENCES "BIOMART"."BIO_ASSAY_FEATURE_GROUP" ("BIO_ASSAY_FEATURE_GROUP_ID") ENABLE;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_ANALYSIS
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_ANALYSIS" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_ASSAY_ANALYSIS_ID", "BIO_ASY_ANALYSIS_DATA_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

--
-- Type: INDEX; Owner: BIOMART; Name: BAAD_IDX_TEA_EXPERIMENT_TYPE
--
CREATE INDEX "BIOMART"."BAAD_IDX_TEA_EXPERIMENT_TYPE" ON "BIOMART"."BIO_ASSAY_ANALYSIS_DATA_TEA" ("BIO_EXPERIMENT_TYPE", "BIO_ASY_ANALYSIS_DATA_ID")
TABLESPACE "INDX" 
PARALLEL 8 ;

