--
-- Type: TABLE; Owner: BIOMART; Name: BIO_PATIENT
--
 CREATE TABLE "BIOMART"."BIO_PATIENT" 
  (	"BIO_PATIENT_ID" NUMBER(18,0) NOT NULL ENABLE, 
"FIRST_NAME" NVARCHAR2(200), 
"LAST_NAME" NVARCHAR2(200), 
"MIDDLE_NAME" NVARCHAR2(200), 
"BIRTH_DATE" DATE, 
"BIRTH_DATE_ORIG" NVARCHAR2(200), 
"GENDER_CODE" NVARCHAR2(200), 
"RACE_CODE" NVARCHAR2(200), 
"ETHNIC_GROUP_CODE" NVARCHAR2(200), 
"ADDRESS_ZIP_CODE" NVARCHAR2(200), 
"COUNTRY_CODE" NVARCHAR2(200), 
"INFORMED_CONSENT_CODE" NVARCHAR2(200), 
"BIO_EXPERIMENT_ID" NUMBER(18,0), 
"BIO_CLINICAL_TRIAL_P_GROUP_ID" NUMBER(18,0), 
 CONSTRAINT "BIO_PATIENT_PK" PRIMARY KEY ("BIO_PATIENT_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_PATIENT_BIO_SUBJECT_FK
--
ALTER TABLE "BIOMART"."BIO_PATIENT" ADD CONSTRAINT "BIO_PATIENT_BIO_SUBJECT_FK" FOREIGN KEY ("BIO_PATIENT_ID")
 REFERENCES "BIOMART"."BIO_SUBJECT" ("BIO_SUBJECT_ID") ENABLE;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_PATIENT_BIO_CLINIC_TRI_FK
--
ALTER TABLE "BIOMART"."BIO_PATIENT" ADD CONSTRAINT "BIO_PATIENT_BIO_CLINIC_TRI_FK" FOREIGN KEY ("BIO_CLINICAL_TRIAL_P_GROUP_ID")
 REFERENCES "BIOMART"."BIO_CLINC_TRIAL_PT_GROUP" ("BIO_CLINICAL_TRIAL_P_GROUP_ID") ENABLE;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_PATIENT_BIO_CLINICAL_TRIAL
--
ALTER TABLE "BIOMART"."BIO_PATIENT" ADD CONSTRAINT "BIO_PATIENT_BIO_CLINICAL_TRIAL" FOREIGN KEY ("BIO_EXPERIMENT_ID")
 REFERENCES "BIOMART"."BIO_CLINICAL_TRIAL" ("BIO_EXPERIMENT_ID") ENABLE;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_PATIENT_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_PATIENT_ID" before insert on "BIO_PATIENT"    for each row begin     if inserting then       if :NEW."BIO_PATIENT_ID" is null then          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_PATIENT_ID" from dual;       end if;    end if; end;













/
ALTER TRIGGER "BIOMART"."TRG_BIO_PATIENT_ID" ENABLE;
 
