--
-- Type: VIEW; Owner: BIOMART; Name: CTD_DRUG_EFFECTS_VIEW
--
  CREATE OR REPLACE FORCE VIEW "BIOMART"."CTD_DRUG_EFFECTS_VIEW" ("ID", "REF_ARTICLE_PROTOCOL_ID", "DISCONTINUATION_RATE", "RESPONSE_RATE", "DOWNSTREAM_SIGNALING_EFFECTS", "BENEFICIAL_EFFECTS", "ADVERSE_EFFECTS", "PK_PD_PARAMETER", "PK_PD_VALUE", "EFFECT_DESCRIPTION") AS 
  select rownum as ID, v."REF_ARTICLE_PROTOCOL_ID",v."DISCONTINUATION_RATE",v."RESPONSE_RATE",v."DOWNSTREAM_SIGNALING_EFFECTS",v."BENEFICIAL_EFFECTS",v."ADVERSE_EFFECTS",v."PK_PD_PARAMETER",v."PK_PD_VALUE",v."EFFECT_DESCRIPTION"
from 
(
select distinct REF_ARTICLE_PROTOCOL_ID,
			DISCONTINUATION_RATE,
			RESPONSE_RATE,
			DOWNSTREAM_SIGNALING_EFFECTS,
			BENEFICIAL_EFFECTS,
			ADVERSE_EFFECTS,
			PK_PD_PARAMETER,
			PK_PD_VALUE,
			EFFECT_DESCRIPTION
from ctd_full
order by REF_ARTICLE_PROTOCOL_ID, BENEFICIAL_EFFECTS, ADVERSE_EFFECTS
) v
 
 
 
 
 
;
 
