--
-- Type: TABLE; Owner: BIOMART_USER; Name: GENE_ONTOLOGY_DATA
--
 CREATE TABLE "BIOMART_USER"."GENE_ONTOLOGY_DATA" 
  (	"PATHWAY" VARCHAR2(100 BYTE), 
"GENE_ID" VARCHAR2(20 BYTE), 
"GENE_SYMBOL" VARCHAR2(200 BYTE), 
"ORGANISM" VARCHAR2(100 BYTE)
  ) SEGMENT CREATION IMMEDIATE
NOCOMPRESS LOGGING
 TABLESPACE "TRANSMART" ;
--
-- Type: INDEX; Owner: BIOMART_USER; Name: IDX_GOD_SYMBOL
--
CREATE INDEX "BIOMART_USER"."IDX_GOD_SYMBOL" ON "BIOMART_USER"."GENE_ONTOLOGY_DATA" (UPPER("GENE_SYMBOL"))
TABLESPACE "TRANSMART" ;
--
-- Type: INDEX; Owner: BIOMART_USER; Name: IDX_GOD_ORGANISM
--
CREATE BITMAP INDEX "BIOMART_USER"."IDX_GOD_ORGANISM" ON "BIOMART_USER"."GENE_ONTOLOGY_DATA" (UPPER("ORGANISM"))
TABLESPACE "TRANSMART" ;
