--
-- Type: TABLE; Owner: DEAPP; Name: DE_PATHWAY
--
 CREATE TABLE "DEAPP"."DE_PATHWAY" 
  (	"NAME" NVARCHAR2(300), 
"DESCRIPTION" NVARCHAR2(510), 
"ID" NUMBER(18,0) NOT NULL ENABLE, 
"TYPE" NVARCHAR2(100), 
"SOURCE" NVARCHAR2(100), 
"EXTERNALID" NVARCHAR2(100), 
"PATHWAY_UID" VARCHAR2(200 BYTE), 
"USER_ID" NUMBER(18,0), 
 CONSTRAINT "DE_PATHWAY_PK" PRIMARY KEY ("ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_DE_PATHWAY_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_DE_PATHWAY_ID" before insert on "DE_PATHWAY"    for each row
begin     if inserting then       if :NEW."ID" is null then          select SEQ_DATA_ID.nextval into :NEW."ID" from dual;       end if;    end if; end;



/
ALTER TRIGGER "DEAPP"."TRG_DE_PATHWAY_ID" ENABLE;
 
--
-- Type: INDEX; Owner: DEAPP; Name: DE_PATHWAY_NAME_IDX
--
CREATE INDEX "DEAPP"."DE_PATHWAY_NAME_IDX" ON "DEAPP"."DE_PATHWAY" ("NAME")
TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: DEAPP; Name: DE_PATHWAY_IDX3
--
CREATE INDEX "DEAPP"."DE_PATHWAY_IDX3" ON "DEAPP"."DE_PATHWAY" ("PATHWAY_UID", "ID")
TABLESPACE "TRANSMART" ;

