--
-- Type: TABLE; Owner: DEAPP; Name: DE_PROTEIN_ANNOTATION
--
 CREATE TABLE "DEAPP"."DE_PROTEIN_ANNOTATION" 
  (	"ID" NUMBER(*,0) NOT NULL ENABLE, 
"GPL_ID" VARCHAR2(50 BYTE) NOT NULL ENABLE, 
"PEPTIDE" VARCHAR2(200 CHAR) NOT NULL ENABLE, 
"UNIPROT_ID" VARCHAR2(200 BYTE), 
"BIOMARKER_ID" NVARCHAR2(200), 
"ORGANISM" VARCHAR2(200 CHAR), 
"UNIPROT_NAME" VARCHAR2(200 CHAR), 
"CHROMOSOME" VARCHAR2(5 CHAR),
"START_BP" NUMBER,
"END_BP" NUMBER,
 PRIMARY KEY ("ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: SEQUENCE; Owner: DEAPP; Name: PROTEIN_ANNOTATION_ID
--
CREATE SEQUENCE  "DEAPP"."PROTEIN_ANNOTATION_ID"  MINVALUE 1 MAXVALUE 999999999 INCREMENT BY 1 START WITH 4742232 NOCACHE  NOORDER  NOCYCLE ;

--
-- Type: TRIGGER; Owner: DEAPP; Name: PROTEOMICS_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."PROTEOMICS_ID" 
   before insert on "DEAPP"."DE_PROTEIN_ANNOTATION" 
   for each row 
begin  
   if inserting then 
      if :NEW."ID" is null then 
         select PROTEIN_ANNOTATION_ID.nextval into :NEW."ID" from dual; 
      end if; 
   end if; 
end;
/
ALTER TRIGGER "DEAPP"."PROTEOMICS_ID" ENABLE;
 
