--
-- Type: TABLE; Owner: DEAPP; Name: DE_SNP_DATA_BY_PATIENT
--
 CREATE TABLE "DEAPP"."DE_SNP_DATA_BY_PATIENT" 
  (	"SNP_DATA_BY_PATIENT_ID" NUMBER(22,0) NOT NULL ENABLE, 
"SNP_DATASET_ID" NUMBER(22,0), 
"TRIAL_NAME" VARCHAR2(255 BYTE), 
"PATIENT_NUM" NUMBER, 
"CHROM" VARCHAR2(16 BYTE), 
"DATA_BY_PATIENT_CHR" CLOB, 
"PED_BY_PATIENT_CHR" CLOB, 
 PRIMARY KEY ("SNP_DATA_BY_PATIENT_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" 
LOB ("DATA_BY_PATIENT_CHR") STORE AS BASICFILE (
 TABLESPACE "TRANSMART" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
 NOCACHE NOLOGGING ) 
LOB ("PED_BY_PATIENT_CHR") STORE AS BASICFILE (
 TABLESPACE "TRANSMART" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
 NOCACHE NOLOGGING ) ;

--
-- Type: REF_CONSTRAINT; Owner: DEAPP; Name: FK_SNP_DATASET_ID
--
ALTER TABLE "DEAPP"."DE_SNP_DATA_BY_PATIENT" ADD CONSTRAINT "FK_SNP_DATASET_ID" FOREIGN KEY ("SNP_DATASET_ID")
 REFERENCES "DEAPP"."DE_SUBJECT_SNP_DATASET" ("SUBJECT_SNP_DATASET_ID") ENABLE;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_SNP_DATA_BY_PATIENT_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_SNP_DATA_BY_PATIENT_ID" 
before insert on DE_SNP_DATA_BY_PATIENT
for each row
begin
   if inserting then
      if :NEW.SNP_DATA_BY_PATIENT_ID is null then
         select SEQ_DATA_ID.nextval into :NEW.SNP_DATA_BY_PATIENT_ID from dual;
      end if;
  end if;
end;

/
ALTER TRIGGER "DEAPP"."TRG_SNP_DATA_BY_PATIENT_ID" ENABLE;
 
