--
-- Type: TABLE; Owner: DEAPP; Name: DE_SNP_DATA_DATASET_LOC
--
 CREATE TABLE "DEAPP"."DE_SNP_DATA_DATASET_LOC" 
  (	"SNP_DATA_DATASET_LOC_ID" NUMBER(22,0) NOT NULL ENABLE, 
"TRIAL_NAME" VARCHAR2(255 BYTE), 
"SNP_DATASET_ID" NUMBER(22,0), 
"LOCATION" NUMBER, 
 PRIMARY KEY ("SNP_DATA_DATASET_LOC_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_SNP_DATA_DATASET_LOC_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_SNP_DATA_DATASET_LOC_ID" 
before insert on DE_SNP_DATA_DATASET_LOC
for each row
begin
   if inserting then
      if :NEW.SNP_DATA_DATASET_LOC_ID is null then
         select SEQ_DATA_ID.nextval into :NEW.SNP_DATA_DATASET_LOC_ID from dual;
      end if;
  end if;
end;

/
ALTER TRIGGER "DEAPP"."TRG_SNP_DATA_DATASET_LOC_ID" ENABLE;
 
--
-- Type: REF_CONSTRAINT; Owner: DEAPP; Name: FK_SNP_LOC_DATASET_ID
--
ALTER TABLE "DEAPP"."DE_SNP_DATA_DATASET_LOC" ADD CONSTRAINT "FK_SNP_LOC_DATASET_ID" FOREIGN KEY ("SNP_DATASET_ID")
 REFERENCES "DEAPP"."DE_SUBJECT_SNP_DATASET" ("SUBJECT_SNP_DATASET_ID") ENABLE;

