--
-- Type: TABLE; Owner: DEAPP; Name: DE_SNP_PROBE
--
 CREATE TABLE "DEAPP"."DE_SNP_PROBE" 
  (	"SNP_PROBE_ID" NUMBER(22,0) NOT NULL ENABLE, 
"PROBE_NAME" VARCHAR2(255 BYTE), 
"SNP_ID" NUMBER(22,0), 
"SNP_NAME" VARCHAR2(255 BYTE), 
"VENDOR_NAME" VARCHAR2(255 BYTE), 
 PRIMARY KEY ("SNP_PROBE_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE, 
 CONSTRAINT "U_SNP_PROBE_NAME" UNIQUE ("PROBE_NAME")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: DEAPP; Name: FK_SNP_PROBE_SNP_ID
--
ALTER TABLE "DEAPP"."DE_SNP_PROBE" ADD CONSTRAINT "FK_SNP_PROBE_SNP_ID" FOREIGN KEY ("SNP_ID")
 REFERENCES "DEAPP"."DE_SNP_INFO" ("SNP_INFO_ID") ENABLE;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_DE_SNP_PROBE_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_DE_SNP_PROBE_ID" 
before insert on DE_SNP_PROBE
for each row
begin
   if inserting then
      if :NEW.SNP_PROBE_ID is null then
         select SEQ_DATA_ID.nextval into :NEW.SNP_PROBE_ID from dual;
      end if;
  end if;
end;

/
ALTER TRIGGER "DEAPP"."TRG_DE_SNP_PROBE_ID" ENABLE;
 
