--
-- Type: TABLE; Owner: I2B2DEMODATA; Name: CONCEPT_DIMENSION
--
 CREATE TABLE "I2B2DEMODATA"."CONCEPT_DIMENSION" 
  (	"CONCEPT_CD" VARCHAR2(50 BYTE) NOT NULL ENABLE, 
"CONCEPT_PATH" VARCHAR2(700 BYTE) NOT NULL ENABLE, 
"NAME_CHAR" VARCHAR2(2000 BYTE), 
"CONCEPT_BLOB" CLOB, 
"UPDATE_DATE" DATE, 
"DOWNLOAD_DATE" DATE, 
"IMPORT_DATE" DATE, 
"SOURCESYSTEM_CD" VARCHAR2(50 BYTE), 
"UPLOAD_ID" NUMBER, 
"TABLE_NAME" VARCHAR2(255 BYTE), 
 CONSTRAINT "CONCEPT_DIMENSION_PK" PRIMARY KEY ("CONCEPT_PATH")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" 
LOB ("CONCEPT_BLOB") STORE AS BASICFILE (
 TABLESPACE "TRANSMART" ENABLE STORAGE IN ROW CHUNK 8192 PCTVERSION 10
 NOCACHE NOLOGGING ) ;

--
-- Type: INDEX; Owner: I2B2DEMODATA; Name: IDX_CONCEPT_DIM_1
--
CREATE INDEX "I2B2DEMODATA"."IDX_CONCEPT_DIM_1" ON "I2B2DEMODATA"."CONCEPT_DIMENSION" ("CONCEPT_CD")
TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: I2B2DEMODATA; Name: TRG_CONCEPT_DIMENSION_CD
--
  CREATE OR REPLACE TRIGGER "I2B2DEMODATA"."TRG_CONCEPT_DIMENSION_CD" 
	 before insert on "CONCEPT_DIMENSION"
	 for each row begin
	 if inserting then
	 if :NEW."CONCEPT_CD" is null then
	 select CONCEPT_ID.nextval into :NEW."CONCEPT_CD" from dual;
	 end if;
	 end if;
	 end;

/
ALTER TRIGGER "I2B2DEMODATA"."TRG_CONCEPT_DIMENSION_CD" ENABLE;
 
