--
-- Type: TABLE; Owner: SEARCHAPP; Name: SEARCH_KEYWORD
--
 CREATE TABLE "SEARCHAPP"."SEARCH_KEYWORD" 
  (	"KEYWORD" NVARCHAR2(400), 
"BIO_DATA_ID" NUMBER(18,0), 
"UNIQUE_ID" NVARCHAR2(500) NOT NULL ENABLE, 
"SEARCH_KEYWORD_ID" NUMBER(18,0) NOT NULL ENABLE, 
"DATA_CATEGORY" NVARCHAR2(200) NOT NULL ENABLE, 
"SOURCE_CODE" NVARCHAR2(100), 
"DISPLAY_DATA_CATEGORY" NVARCHAR2(200), 
"OWNER_AUTH_USER_ID" NUMBER, 
 CONSTRAINT "SEARCH_KW_PK" PRIMARY KEY ("SEARCH_KEYWORD_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE, 
 CONSTRAINT "SEARCH_KEYWORD_UK" UNIQUE ("UNIQUE_ID", "DATA_CATEGORY")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: SEARCHAPP; Name: SCH_KWD_DT_CAT_IDX
--
CREATE INDEX "SEARCHAPP"."SCH_KWD_DT_CAT_IDX" ON "SEARCHAPP"."SEARCH_KEYWORD" ("DATA_CATEGORY")
TABLESPACE "INDX" ;

--
-- Type: INDEX; Owner: SEARCHAPP; Name: IDX_SK_DISPLAY_CATEGORY1
--
CREATE BITMAP INDEX "SEARCHAPP"."IDX_SK_DISPLAY_CATEGORY1" ON "SEARCHAPP"."SEARCH_KEYWORD" ("DATA_CATEGORY", "DISPLAY_DATA_CATEGORY")
TABLESPACE "INDX" 
PARALLEL ;
--
-- Type: INDEX; Owner: SEARCHAPP; Name: SEARCH_KEYWORD_INDEX3
--
CREATE INDEX "SEARCHAPP"."SEARCH_KEYWORD_INDEX3" ON "SEARCHAPP"."SEARCH_KEYWORD" ("OWNER_AUTH_USER_ID")
TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: SEARCHAPP; Name: SEARCH_KEYWORD_INDEX2
--
CREATE INDEX "SEARCHAPP"."SEARCH_KEYWORD_INDEX2" ON "SEARCHAPP"."SEARCH_KEYWORD" ("BIO_DATA_ID")
TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: SEARCHAPP; Name: SEARCH_KEYWORD_INDEX1
--
CREATE INDEX "SEARCHAPP"."SEARCH_KEYWORD_INDEX1" ON "SEARCHAPP"."SEARCH_KEYWORD" ("KEYWORD")
TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: SEARCHAPP; Name: TRG_SEARCH_KEYWORD_ID
--
  CREATE OR REPLACE TRIGGER "SEARCHAPP"."TRG_SEARCH_KEYWORD_ID" before insert on "SEARCH_KEYWORD"    for each row begin     if inserting then       if :NEW."SEARCH_KEYWORD_ID" is null then          select SEQ_SEARCH_DATA_ID.nextval into :NEW."SEARCH_KEYWORD_ID" from dual;       end if;    end if; end;











/
ALTER TRIGGER "SEARCHAPP"."TRG_SEARCH_KEYWORD_ID" ENABLE;
 
