--
-- Type: TABLE; Owner: TM_CZ; Name: AZ_TEST_RUN
--
 CREATE TABLE "TM_CZ"."AZ_TEST_RUN" 
  (	"TEST_RUN_ID" NUMBER(18,0) NOT NULL ENABLE, 
"DW_VERSION_ID" NUMBER(18,0), 
"START_DATE" DATE, 
"END_DATE" DATE, 
"STATUS" VARCHAR2(20 BYTE), 
"RETURN_CODE" VARCHAR2(30 BYTE), 
"RETURN_MESSAGE" VARCHAR2(4000 BYTE), 
"TEST_RUN_NAME" VARCHAR2(200 BYTE), 
"PARAM1" VARCHAR2(4000 BYTE), 
"TEST_CATEGORY_ID" NUMBER, 
 CONSTRAINT "AZ_TEST_RUN_PK" PRIMARY KEY ("TEST_RUN_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: TM_CZ; Name: TRG_AZ_TEST_RUN_ID
--
  CREATE OR REPLACE TRIGGER "TM_CZ"."TRG_AZ_TEST_RUN_ID" 
before insert on AZ_TEST_RUN    for each row 
begin     
  if inserting then       
    if :NEW.TEST_RUN_ID is null then          
      select SEQ_CZ_TEST.nextval into :NEW.TEST_RUN_ID from dual;       
    end if;   
  end if; 
end;






/
ALTER TRIGGER "TM_CZ"."TRG_AZ_TEST_RUN_ID" ENABLE;
 
--
-- Type: REF_CONSTRAINT; Owner: TM_CZ; Name: AZ_TEST_RUN_CZ_TEST_CATEG_FK1
--
ALTER TABLE "TM_CZ"."AZ_TEST_RUN" ADD CONSTRAINT "AZ_TEST_RUN_CZ_TEST_CATEG_FK1" FOREIGN KEY ("TEST_CATEGORY_ID")
 REFERENCES "TM_CZ"."CZ_TEST_CATEGORY" ("TEST_CATEGORY_ID") ENABLE;

--
-- Type: REF_CONSTRAINT; Owner: TM_CZ; Name: AZ_TEST_RUN_CZ_DW_VERSION_FK1
--
ALTER TABLE "TM_CZ"."AZ_TEST_RUN" ADD CONSTRAINT "AZ_TEST_RUN_CZ_DW_VERSION_FK1" FOREIGN KEY ("DW_VERSION_ID")
 REFERENCES "TM_CZ"."CZ_DW_VERSION" ("DW_VERSION_ID") ENABLE;

