--
-- Type: TABLE; Owner: TM_CZ; Name: AZ_TEST_STEP_ACT_RESULT
--
 CREATE TABLE "TM_CZ"."AZ_TEST_STEP_ACT_RESULT" 
  (	"TEST_STEP_ACT_RESULT_ID" NUMBER(18,0) NOT NULL ENABLE, 
"TEST_STEP_RUN_ID" NUMBER(18,0) NOT NULL ENABLE, 
"ACT_RECORD_CNT" NUMBER(18,4), 
"RETURN_CODE" VARCHAR2(30 BYTE), 
"RETURN_MESSAGE" VARCHAR2(4000 BYTE), 
"RETURN_ERROR_STACK" VARCHAR2(4000 BYTE), 
"RETURN_ERROR_BACK_TRACE" VARCHAR2(4000 BYTE), 
 CONSTRAINT "AZ_TEST_STEP_ACT_RESULT_PK" PRIMARY KEY ("TEST_STEP_ACT_RESULT_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: TM_CZ; Name: AZ_TEST_STEP_ACT_RESULT_AZ_FK1
--
ALTER TABLE "TM_CZ"."AZ_TEST_STEP_ACT_RESULT" ADD CONSTRAINT "AZ_TEST_STEP_ACT_RESULT_AZ_FK1" FOREIGN KEY ("TEST_STEP_RUN_ID")
 REFERENCES "TM_CZ"."AZ_TEST_STEP_RUN" ("TEST_STEP_RUN_ID") ENABLE;

--
-- Type: TRIGGER; Owner: TM_CZ; Name: TRG_AZ_TEST_STEP_ACT_RESULT
--
  CREATE OR REPLACE TRIGGER "TM_CZ"."TRG_AZ_TEST_STEP_ACT_RESULT" 
before insert on AZ_TEST_STEP_ACT_RESULT    for each row 
begin     
  if inserting then       
    if :NEW.TEST_STEP_ACT_RESULT_ID is null then          
      select SEQ_CZ_TEST.nextval into :NEW.TEST_STEP_ACT_RESULT_ID from dual;       
    end if;   
  end if; 
end;






/
ALTER TRIGGER "TM_CZ"."TRG_AZ_TEST_STEP_ACT_RESULT" ENABLE;
 
