--
-- Type: TABLE; Owner: TM_LZ; Name: LZ_SRC_ANALYSIS_METADATA
--
 CREATE TABLE "TM_LZ"."LZ_SRC_ANALYSIS_METADATA" 
  (	"STUDY_ID" VARCHAR2(50 BYTE), 
"DATA_TYPE" VARCHAR2(50 BYTE), 
"ANALYSIS_NAME" VARCHAR2(500 BYTE), 
"DESCRIPTION" VARCHAR2(2048 BYTE), 
"PHENOTYPE_IDS" VARCHAR2(250 BYTE), 
"POPULATION" VARCHAR2(500 BYTE), 
"TISSUE" VARCHAR2(500 BYTE), 
"GENOME_VERSION" VARCHAR2(50 BYTE), 
"GENOTYPE_PLATFORM_IDS" VARCHAR2(500 BYTE), 
"EXPRESSION_PLATFORM_IDS" VARCHAR2(500 BYTE), 
"STATISTICAL_TEST" VARCHAR2(500 BYTE), 
"RESEARCH_UNIT" VARCHAR2(500 BYTE), 
"SAMPLE_SIZE" VARCHAR2(500 BYTE), 
"CELL_TYPE" VARCHAR2(500 BYTE), 
"PVALUE_CUTOFF" VARCHAR2(50 BYTE), 
"ETL_DATE" TIMESTAMP (6), 
"FILENAME" VARCHAR2(500 BYTE), 
"STATUS" VARCHAR2(50 BYTE), 
"PROCESS_DATE" TIMESTAMP (6), 
"ETL_ID" NUMBER(38,0), 
"ANALYSIS_NAME_ARCHIVED" VARCHAR2(500 BYTE), 
"MODEL_NAME" VARCHAR2(500 BYTE), 
"MODEL_DESC" VARCHAR2(500 BYTE), 
"SENSITIVE_FLAG" NUMBER(18,0), 
"SENSITIVE_DESC" VARCHAR2(500 BYTE)
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: SEQUENCE; Owner: TM_LZ; Name: SEQ_ETL_ID
--
CREATE SEQUENCE  "TM_LZ"."SEQ_ETL_ID"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  NOORDER  NOCYCLE ;

--
-- Type: TRIGGER; Owner: TM_LZ; Name: TRG_LZ_SRC_ANALYSIS_META_ID
--
  CREATE OR REPLACE TRIGGER "TM_LZ"."TRG_LZ_SRC_ANALYSIS_META_ID" 
before insert on tm_lz.lz_src_analysis_metadata
for each row begin
       	if inserting then
               	if :NEW.etl_id is null then
                       	select seq_etl_id.nextval into :NEW.etl_id from dual;
               	end if;
       	end if;
end;
/
ALTER TRIGGER "TM_LZ"."TRG_LZ_SRC_ANALYSIS_META_ID" ENABLE;
 
