--
-- Type: TABLE; Owner: AMAPP; Name: AM_TAG_ITEM
--
 CREATE TABLE "AMAPP"."AM_TAG_ITEM" 
  (	"TAG_TEMPLATE_ID" NUMBER NOT NULL ENABLE, 
"TAG_ITEM_ID" NUMBER NOT NULL ENABLE, 
"REQUIRED" NVARCHAR2(1), 
"DISPLAY_ORDER" NUMBER, 
"DISPLAY_NAME" NVARCHAR2(200) NOT NULL ENABLE, 
"GUI_HANDLER" NVARCHAR2(200) NOT NULL ENABLE, 
"MAX_VALUES" NUMBER, 
"CODE_TYPE_NAME" NVARCHAR2(200), 
"EDITABLE" NVARCHAR2(1), 
"ACTIVE_IND" CHAR(1 BYTE) NOT NULL ENABLE, 
"TAG_ITEM_UID" NVARCHAR2(300) NOT NULL ENABLE, 
"TAG_ITEM_ATTR" NVARCHAR2(300), 
"TAG_ITEM_TYPE" NVARCHAR2(200), 
"VIEW_IN_GRID" NUMBER(1,0), 
"TAG_ITEM_SUBTYPE" NVARCHAR2(200), 
"VIEW_IN_CHILD_GRID" NUMBER(1,0), 
 PRIMARY KEY ("TAG_TEMPLATE_ID", "TAG_ITEM_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: AMAPP; Name: TRG_AM_TAG_ITEM_ID
--
  CREATE OR REPLACE TRIGGER "AMAPP"."TRG_AM_TAG_ITEM_ID" before insert on "AMAPP"."AM_TAG_ITEM"    
for each row begin    
if inserting then      
  if :NEW."TAG_ITEM_ID" is null then          
    select SEQ_AMAPP_DATA_ID.nextval into :NEW."TAG_ITEM_ID" from dual;       
  end if;    
end if; 
end;
/
ALTER TRIGGER "AMAPP"."TRG_AM_TAG_ITEM_ID" ENABLE;
 
