--
-- Type: TABLE; Owner: AMAPP; Name: AM_TAG_TEMPLATE_ASSOCIATION
--
 CREATE TABLE "AMAPP"."AM_TAG_TEMPLATE_ASSOCIATION" 
  (	"TAG_TEMPLATE_ID" NUMBER NOT NULL ENABLE, 
"OBJECT_UID" NVARCHAR2(300) NOT NULL ENABLE, 
"ID" NUMBER(*,0), 
 PRIMARY KEY ("TAG_TEMPLATE_ID", "OBJECT_UID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: AMAPP; Name: TRG_AM_TAG_TEMP_ASSOC_ID
--
  CREATE OR REPLACE TRIGGER "AMAPP"."TRG_AM_TAG_TEMP_ASSOC_ID" before insert on "AMAPP"."AM_TAG_TEMPLATE_ASSOCIATION"    
for each row begin    
if inserting then      
  if :NEW."ID" is null then          
    select SEQ_AMAPP_DATA_ID.nextval into :NEW."ID" from dual;       
  end if;    
end if; 
end;
/
ALTER TRIGGER "AMAPP"."TRG_AM_TAG_TEMP_ASSOC_ID" ENABLE;
 
