--
-- Type: TABLE; Owner: BIOMART; Name: BIO_CELL_LINE
--
 CREATE TABLE "BIOMART"."BIO_CELL_LINE" 
  (	"DISEASE" NVARCHAR2(510), 
"PRIMARY_SITE" NVARCHAR2(510), 
"METASTATIC_SITE" NVARCHAR2(510), 
"SPECIES" NVARCHAR2(510), 
"ATTC_NUMBER" NVARCHAR2(510), 
"CELL_LINE_NAME" NVARCHAR2(510), 
"BIO_CELL_LINE_ID" NUMBER(18,0) NOT NULL ENABLE, 
"BIO_DISEASE_ID" NUMBER(18,0), 
"ORIGIN" NVARCHAR2(200), 
"DESCRIPTION" NVARCHAR2(500), 
"DISEASE_STAGE" NVARCHAR2(100), 
"DISEASE_SUBTYPE" NVARCHAR2(200), 
"ETL_REFERENCE_LINK" NVARCHAR2(300), 
 CONSTRAINT "CELLLINEDICTIONARY_PK" PRIMARY KEY ("BIO_CELL_LINE_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_CELL_LINE_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_CELL_LINE_ID" before insert on "BIO_CELL_LINE"    for each row begin     if inserting then       if :NEW."BIO_CELL_LINE_ID" is null then          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_CELL_LINE_ID" from dual;       end if;    end if; end;











/
ALTER TRIGGER "BIOMART"."TRG_BIO_CELL_LINE_ID" ENABLE;
 
--
-- Type: INDEX; Owner: BIOMART; Name: BIO_CELL_LINE_NAME_IDX
--
CREATE INDEX "BIOMART"."BIO_CELL_LINE_NAME_IDX" ON "BIOMART"."BIO_CELL_LINE" ("CELL_LINE_NAME", "BIO_CELL_LINE_ID")
TABLESPACE "INDX" 
PARALLEL 3 ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: CD_DISEASE_FK
--
ALTER TABLE "BIOMART"."BIO_CELL_LINE" ADD CONSTRAINT "CD_DISEASE_FK" FOREIGN KEY ("BIO_DISEASE_ID")
 REFERENCES "BIOMART"."BIO_DISEASE" ("BIO_DISEASE_ID") ENABLE;

