--
-- Type: TABLE; Owner: BIOMART; Name: BIO_CONTENT
--
 CREATE TABLE "BIOMART"."BIO_CONTENT" 
  (	"BIO_FILE_CONTENT_ID" NUMBER(18,0) NOT NULL ENABLE, 
"FILE_NAME" NVARCHAR2(1000), 
"REPOSITORY_ID" NUMBER(18,0), 
"LOCATION" NVARCHAR2(400), 
"TITLE" NVARCHAR2(1000), 
"ABSTRACT" NVARCHAR2(2000), 
"FILE_TYPE" NVARCHAR2(200) NOT NULL ENABLE, 
"ETL_ID" NUMBER(18,0), 
"ETL_ID_C" VARCHAR2(30 BYTE), 
"STUDY_NAME" VARCHAR2(30 BYTE), 
"CEL_LOCATION" VARCHAR2(300 BYTE), 
"CEL_FILE_SUFFIX" VARCHAR2(30 BYTE), 
 CONSTRAINT "EXTERNAL_FILE_PK" PRIMARY KEY ("BIO_FILE_CONTENT_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: EXT_FILE_CNT_CNT_REPO_FK
--
ALTER TABLE "BIOMART"."BIO_CONTENT" ADD CONSTRAINT "EXT_FILE_CNT_CNT_REPO_FK" FOREIGN KEY ("REPOSITORY_ID")
 REFERENCES "BIOMART"."BIO_CONTENT_REPOSITORY" ("BIO_CONTENT_REPO_ID") ENABLE;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_FILE_CONTENT_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_FILE_CONTENT_ID" before insert on "BIO_CONTENT"    for each row begin     if inserting then       if :NEW."BIO_FILE_CONTENT_ID" is null then          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_FILE_CONTENT_ID" from dual;       end if;    end if; end;













/
ALTER TRIGGER "BIOMART"."TRG_BIO_FILE_CONTENT_ID" ENABLE;
 
