--
-- Type: TABLE; Owner: BIOMART; Name: BIO_LIT_ALT_DATA
--
 CREATE TABLE "BIOMART"."BIO_LIT_ALT_DATA" 
  (	"BIO_LIT_ALT_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"BIO_LIT_REF_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"IN_VIVO_MODEL_ID" NUMBER(18,0), 
"IN_VITRO_MODEL_ID" NUMBER(18,0), 
"ETL_ID" NVARCHAR2(50), 
"ALTERATION_TYPE" NVARCHAR2(50), 
"CONTROL" NVARCHAR2(1000), 
"EFFECT" NVARCHAR2(500), 
"DESCRIPTION" NVARCHAR2(1000), 
"TECHNIQUES" NVARCHAR2(1000), 
"PATIENTS_PERCENT" NVARCHAR2(500), 
"PATIENTS_NUMBER" NVARCHAR2(500), 
"POP_NUMBER" NVARCHAR2(250), 
"POP_INCLUSION_CRITERIA" NVARCHAR2(1000), 
"POP_EXCLUSION_CRITERIA" NVARCHAR2(1000), 
"POP_DESCRIPTION" NVARCHAR2(1000), 
"POP_TYPE" NVARCHAR2(250), 
"POP_VALUE" NVARCHAR2(250), 
"POP_PHASE" NVARCHAR2(250), 
"POP_STATUS" NVARCHAR2(250), 
"POP_EXPERIMENTAL_MODEL" NVARCHAR2(250), 
"POP_TISSUE" NVARCHAR2(250), 
"POP_BODY_SUBSTANCE" NVARCHAR2(250), 
"POP_LOCALIZATION" NVARCHAR2(1000), 
"POP_CELL_TYPE" NVARCHAR2(250), 
"CLIN_SUBMUCOSA_MARKER_TYPE" NVARCHAR2(250), 
"CLIN_SUBMUCOSA_UNIT" NVARCHAR2(250), 
"CLIN_SUBMUCOSA_VALUE" NVARCHAR2(250), 
"CLIN_ASM_MARKER_TYPE" NVARCHAR2(250), 
"CLIN_ASM_UNIT" NVARCHAR2(250), 
"CLIN_ASM_VALUE" NVARCHAR2(250), 
"CLIN_CELLULAR_SOURCE" NVARCHAR2(250), 
"CLIN_CELLULAR_TYPE" NVARCHAR2(250), 
"CLIN_CELLULAR_COUNT" NVARCHAR2(250), 
"CLIN_PRIOR_MED_PERCENT" NVARCHAR2(250), 
"CLIN_PRIOR_MED_DOSE" NVARCHAR2(250), 
"CLIN_PRIOR_MED_NAME" NVARCHAR2(250), 
"CLIN_BASELINE_VARIABLE" NVARCHAR2(250), 
"CLIN_BASELINE_PERCENT" NVARCHAR2(250), 
"CLIN_BASELINE_VALUE" NVARCHAR2(250), 
"CLIN_SMOKER" NVARCHAR2(250), 
"CLIN_ATOPY" NVARCHAR2(250), 
"CONTROL_EXP_PERCENT" NVARCHAR2(50), 
"CONTROL_EXP_NUMBER" NVARCHAR2(50), 
"CONTROL_EXP_VALUE" NVARCHAR2(50), 
"CONTROL_EXP_SD" NVARCHAR2(50), 
"CONTROL_EXP_UNIT" NVARCHAR2(100), 
"OVER_EXP_PERCENT" NVARCHAR2(50), 
"OVER_EXP_NUMBER" NVARCHAR2(50), 
"OVER_EXP_VALUE" NVARCHAR2(50), 
"OVER_EXP_SD" NVARCHAR2(50), 
"OVER_EXP_UNIT" NVARCHAR2(100), 
"LOSS_EXP_PERCENT" NVARCHAR2(50), 
"LOSS_EXP_NUMBER" NVARCHAR2(50), 
"LOSS_EXP_VALUE" NVARCHAR2(50), 
"LOSS_EXP_SD" NVARCHAR2(50), 
"LOSS_EXP_UNIT" NVARCHAR2(100), 
"TOTAL_EXP_PERCENT" NVARCHAR2(50), 
"TOTAL_EXP_NUMBER" NVARCHAR2(50), 
"TOTAL_EXP_VALUE" NVARCHAR2(50), 
"TOTAL_EXP_SD" NVARCHAR2(50), 
"TOTAL_EXP_UNIT" NVARCHAR2(100), 
"GLC_CONTROL_PERCENT" NVARCHAR2(250), 
"GLC_MOLECULAR_CHANGE" NVARCHAR2(250), 
"GLC_TYPE" NVARCHAR2(50), 
"GLC_PERCENT" NVARCHAR2(100), 
"GLC_NUMBER" NVARCHAR2(100), 
"PTM_REGION" NVARCHAR2(250), 
"PTM_TYPE" NVARCHAR2(250), 
"PTM_CHANGE" NVARCHAR2(250), 
"LOH_LOCI" NVARCHAR2(250), 
"MUTATION_TYPE" NVARCHAR2(250), 
"MUTATION_CHANGE" NVARCHAR2(250), 
"MUTATION_SITES" NVARCHAR2(250), 
"EPIGENETIC_REGION" NVARCHAR2(250), 
"EPIGENETIC_TYPE" NVARCHAR2(250), 
 CONSTRAINT "BIO_LIT_ALT_DATA_PK" PRIMARY KEY ("BIO_LIT_ALT_DATA_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_LIT_ALT_DATA_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_LIT_ALT_DATA_ID" 
before insert on "BIO_LIT_ALT_DATA"
for each row
begin
     if inserting then
       if :NEW."BIO_LIT_ALT_DATA_ID" is null then
          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_LIT_ALT_DATA_ID" from dual;
       end if;
    end if; end;







/
ALTER TRIGGER "BIOMART"."TRG_BIO_LIT_ALT_DATA_ID" ENABLE;
 
--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_LIT_ALT_REF_FK
--
ALTER TABLE "BIOMART"."BIO_LIT_ALT_DATA" ADD CONSTRAINT "BIO_LIT_ALT_REF_FK" FOREIGN KEY ("BIO_LIT_REF_DATA_ID")
 REFERENCES "BIOMART"."BIO_LIT_REF_DATA" ("BIO_LIT_REF_DATA_ID") ENABLE;

