--
-- Type: TABLE; Owner: BIOMART; Name: BIO_LIT_INT_DATA
--
 CREATE TABLE "BIOMART"."BIO_LIT_INT_DATA" 
  (	"BIO_LIT_INT_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"BIO_LIT_REF_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"IN_VIVO_MODEL_ID" NUMBER(18,0), 
"IN_VITRO_MODEL_ID" NUMBER(18,0), 
"ETL_ID" NVARCHAR2(50), 
"SOURCE_COMPONENT" NVARCHAR2(100), 
"SOURCE_GENE_ID" NVARCHAR2(50), 
"TARGET_COMPONENT" NVARCHAR2(100), 
"TARGET_GENE_ID" NVARCHAR2(50), 
"INTERACTION_MODE" NVARCHAR2(250), 
"REGULATION" NVARCHAR2(1000), 
"MECHANISM" NVARCHAR2(250), 
"EFFECT" NVARCHAR2(500), 
"LOCALIZATION" NVARCHAR2(500), 
"REGION" NVARCHAR2(250), 
"TECHNIQUES" NVARCHAR2(1000), 
 CONSTRAINT "BIO_LIT_INT_DATA_PK" PRIMARY KEY ("BIO_LIT_INT_DATA_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_LIT_INT_REF_FK
--
ALTER TABLE "BIOMART"."BIO_LIT_INT_DATA" ADD CONSTRAINT "BIO_LIT_INT_REF_FK" FOREIGN KEY ("BIO_LIT_REF_DATA_ID")
 REFERENCES "BIOMART"."BIO_LIT_REF_DATA" ("BIO_LIT_REF_DATA_ID") ENABLE;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_LIT_INT_DATA_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_LIT_INT_DATA_ID" 
before insert on "BIO_LIT_INT_DATA"
for each row
begin
     if inserting then
       if :NEW."BIO_LIT_INT_DATA_ID" is null then
          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_LIT_INT_DATA_ID" from dual;
       end if;
    end if; end;







/
ALTER TRIGGER "BIOMART"."TRG_BIO_LIT_INT_DATA_ID" ENABLE;
 
