--
-- Type: TABLE; Owner: BIOMART; Name: BIO_LIT_PE_DATA
--
 CREATE TABLE "BIOMART"."BIO_LIT_PE_DATA" 
  (	"BIO_LIT_PE_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"BIO_LIT_REF_DATA_ID" NUMBER(18,0) NOT NULL ENABLE, 
"IN_VIVO_MODEL_ID" NUMBER(18,0), 
"IN_VITRO_MODEL_ID" NUMBER(18,0), 
"ETL_ID" NVARCHAR2(50), 
"DESCRIPTION" NVARCHAR2(2000), 
 CONSTRAINT "BIO_LIT_PE_DATA_PK" PRIMARY KEY ("BIO_LIT_PE_DATA_ID")
 USING INDEX
 TABLESPACE "INDX"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: REF_CONSTRAINT; Owner: BIOMART; Name: BIO_LIT_PE_REF_FK
--
ALTER TABLE "BIOMART"."BIO_LIT_PE_DATA" ADD CONSTRAINT "BIO_LIT_PE_REF_FK" FOREIGN KEY ("BIO_LIT_REF_DATA_ID")
 REFERENCES "BIOMART"."BIO_LIT_REF_DATA" ("BIO_LIT_REF_DATA_ID") ENABLE;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_LIT_PE_DATA_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_LIT_PE_DATA_ID" 
before insert on "BIO_LIT_PE_DATA"
for each row
begin
     if inserting then
       if :NEW."BIO_LIT_PE_DATA_ID" is null then
          select SEQ_BIO_DATA_ID.nextval into :NEW."BIO_LIT_PE_DATA_ID" from dual;
       end if;
    end if; end;







/
ALTER TRIGGER "BIOMART"."TRG_BIO_LIT_PE_DATA_ID" ENABLE;
 
