--
-- Type: TABLE; Owner: BIOMART; Name: BIO_OBSERVATION
--
 CREATE TABLE "BIOMART"."BIO_OBSERVATION" 
  (	"BIO_OBSERVATION_ID" NUMBER(18,0) NOT NULL ENABLE, 
"OBS_NAME" NVARCHAR2(200), 
"OBS_CODE" NVARCHAR2(50), 
"OBS_DESCR" NVARCHAR2(1000), 
"ETL_ID" VARCHAR2(50 BYTE), 
"OBS_TYPE" NVARCHAR2(20), 
"OBS_CODE_SOURCE" NVARCHAR2(20), 
 CONSTRAINT "OBSERVATIONDIM_PK" PRIMARY KEY ("BIO_OBSERVATION_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: BIOMART; Name: TRG_BIO_OBSERVATION_ID
--
  CREATE OR REPLACE TRIGGER "BIOMART"."TRG_BIO_OBSERVATION_ID" 
before insert on BIO_OBSERVATION
for each row
begin
  if inserting then
     if :NEW.BIO_OBSERVATION_ID is null then
        select SEQ_BIO_DATA_ID.nextval into :NEW.BIO_OBSERVATION_ID from dual;
     end if;
  end if;
end;
/
ALTER TRIGGER "BIOMART"."TRG_BIO_OBSERVATION_ID" ENABLE;
 
