--
-- Type: VIEW; Owner: BIOMART; Name: CTD_STATS_VIEW
--
  CREATE OR REPLACE FORCE VIEW "BIOMART"."CTD_STATS_VIEW" ("ID", "REF_ARTICLE_PROTOCOL_ID", "CLINICAL_CORRELATION", "STATISTICAL_TEST", "STATISTICAL_COEFFICIENT_VALUE", "STATISTICAL_TEST_P_VALUE", "STATISTICAL_TEST_DESCRIPTION") AS 
  select rownum as ID, v."REF_ARTICLE_PROTOCOL_ID",v."CLINICAL_CORRELATION",v."STATISTICAL_TEST",v."STATISTICAL_COEFFICIENT_VALUE",v."STATISTICAL_TEST_P_VALUE",v."STATISTICAL_TEST_DESCRIPTION"
from 
(
select distinct REF_ARTICLE_PROTOCOL_ID,
			CLINICAL_CORRELATION,
			STATISTICAL_TEST,
			STATISTICAL_COEFFICIENT_VALUE,
			STATISTICAL_TEST_P_VALUE,
			STATISTICAL_TEST_DESCRIPTION
from ctd_full
where STATISTICAL_TEST_DESCRIPTION is not null or STATISTICAL_TEST is not null
order by REF_ARTICLE_PROTOCOL_ID, STATISTICAL_TEST
) v
 
 
 
 
 
;
 
