--
-- Type: VIEW; Owner: BIOMART; Name: CTD_TD_INCLUSION_VIEW
--
  CREATE OR REPLACE FORCE VIEW "BIOMART"."CTD_TD_INCLUSION_VIEW" ("ID", "REF_ARTICLE_PROTOCOL_ID", "TRIAL_AGE", "DISEASE_SEVERITY", "DIFFICULT_TO_TREAT", "ASTHMA_DIAGNOSIS", "INHALED_STEROID_DOSE", "LABA", "OCS", "XOLAIR", "LTRA_INHIBITORS", "ASTHMA_PHENOTYPE", "FEV1", "FEV1_REVERSIBILITY", "TLC", "FEV1_FVC", "FVC", "DLCO", "SGRQ", "HRCT", "BIOPSY", "DYSPNEA_ON_EXERTION", "CONCOMITANT_MED") AS 
  select rownum as ID, v."REF_ARTICLE_PROTOCOL_ID",v."TRIAL_AGE",v."DISEASE_SEVERITY",v."DIFFICULT_TO_TREAT",v."ASTHMA_DIAGNOSIS",v."INHALED_STEROID_DOSE",v."LABA",v."OCS",v."XOLAIR",v."LTRA_INHIBITORS",v."ASTHMA_PHENOTYPE",v."FEV1",v."FEV1_REVERSIBILITY",v."TLC",v."FEV1_FVC",v."FVC",v."DLCO",v."SGRQ",v."HRCT",v."BIOPSY",v."DYSPNEA_ON_EXERTION",v."CONCOMITANT_MED"
 from (
 select distinct REF_ARTICLE_PROTOCOL_ID,
       TRIAL_AGE,
       DISEASE_SEVERITY,
       DIFFICULT_TO_TREAT,
       ASTHMA_DIAGNOSIS,
       INHALED_STEROID_DOSE,
       LABA,
       OCS,
       XOLAIR,
       LTRA_INHIBITORS,
       ASTHMA_PHENOTYPE,
       FEV1,
       FEV1_REVERSIBILITY,
       TLC,
       FEV1_FVC,
       FVC,
       DLCO,
       SGRQ,
       HRCT,
       BIOPSY,
       DYSPNEA_ON_EXERTION,
       CONCOMITANT_MED
 from ctd_full
 where FEV1 is not null or  DISEASE_SEVERITY is not null or TRIAL_AGE is not null
 order by REF_ARTICLE_PROTOCOL_ID, DISEASE_SEVERITY, FEV1
 ) v





;
 
