--
-- Type: VIEW; Owner: BIOMART; Name: CTD_TREATMENT_PHASES_VIEW
--
  CREATE OR REPLACE FORCE VIEW "BIOMART"."CTD_TREATMENT_PHASES_VIEW" ("ID", "REF_ARTICLE_PROTOCOL_ID", "TRTMT_OCS", "TRTMT_ICS", "TRTMT_LABA", "TRTMT_LTRA", "TRTMT_CORTICOSTEROIDS", "TRTMT_ANTI_FIBROTICS", "TRTMT_IMMUNOSUPPRESSIVE", "TRTMT_CYTOTOXIC", "TRTMT_DESCRIPTION") AS 
  select rownum as ID, v."REF_ARTICLE_PROTOCOL_ID",v."TRTMT_OCS",v."TRTMT_ICS",v."TRTMT_LABA",v."TRTMT_LTRA",v."TRTMT_CORTICOSTEROIDS",v."TRTMT_ANTI_FIBROTICS",v."TRTMT_IMMUNOSUPPRESSIVE",v."TRTMT_CYTOTOXIC",v."TRTMT_DESCRIPTION"
from 
(
select distinct REF_ARTICLE_PROTOCOL_ID,
			TRTMT_OCS,
			TRTMT_ICS,
			TRTMT_LABA,
			TRTMT_LTRA,
			TRTMT_CORTICOSTEROIDS,
			TRTMT_ANTI_FIBROTICS,
			TRTMT_IMMUNOSUPPRESSIVE,
			TRTMT_CYTOTOXIC,
			TRTMT_DESCRIPTION
from ctd_full
where TRTMT_OCS is not null or TRTMT_DESCRIPTION is not null or TRTMT_IMMUNOSUPPRESSIVE is not null
order by REF_ARTICLE_PROTOCOL_ID, TRTMT_DESCRIPTION, TRTMT_OCS
) v
 
 
 
 
 
;
 
