--
-- Type: SEQUENCE; Owner: DEAPP; Name: DE_RC_SNP_INFO_SEQ
--
CREATE SEQUENCE  "DEAPP"."DE_RC_SNP_INFO_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  NOORDER  NOCYCLE ;

--
-- Type: TABLE; Owner: DEAPP; Name: DE_RC_SNP_INFO
--
 CREATE TABLE "DEAPP"."DE_RC_SNP_INFO" 
  (	"SNP_INFO_ID" NUMBER NOT NULL ENABLE, 
"RS_ID" VARCHAR2(50 BYTE), 
"CHROM" VARCHAR2(4 BYTE), 
"POS" NUMBER, 
"REF" VARCHAR2(1000 BYTE), 
"ALT" VARCHAR2(1000 BYTE), 
"GENE_INFO" VARCHAR2(1000 BYTE), 
"VARIATION_CLASS" VARCHAR2(10 BYTE), 
"STRAND" VARCHAR2(1 BYTE), 
"CLINSIG" VARCHAR2(100 BYTE), 
"DISEASE" VARCHAR2(500 BYTE), 
"GMAF" VARCHAR2(10 BYTE), 
"GENE_BIOTYPE" VARCHAR2(100 BYTE), 
"IMPACT" VARCHAR2(50 BYTE), 
"TRANSCRIPT_ID" VARCHAR2(100 BYTE), 
"FUNCTIONAL_CLASS" VARCHAR2(100 BYTE), 
"EFFECT" VARCHAR2(100 BYTE), 
"EXON_ID" VARCHAR2(100 BYTE), 
"AMINO_ACID_CHANGE" VARCHAR2(100 BYTE), 
"CODON_CHANGE" VARCHAR2(1000 BYTE), 
"HG_VERSION" VARCHAR2(10 BYTE), 
"GENE_NAME" VARCHAR2(50 BYTE), 
"ENTREZ_ID" VARCHAR2(50 BYTE), 
"RECOMBINATION_RATE" NUMBER(18,6), 
"RECOMBINATION_MAP" NUMBER(18,6), 
"REGULOME_SCORE" VARCHAR2(10 BYTE), 
"EXON_INTRON" VARCHAR2(10 BYTE)
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_DE_RC_SNP_INFO_ID
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_DE_RC_SNP_INFO_ID" 
before insert on "DEAPP"."DE_RC_SNP_INFO"
for each row begin
       	if inserting then
               	if :NEW."SNP_INFO_ID" is null then
                       	select DE_RC_SNP_INFO_SEQ.nextval into :NEW."SNP_INFO_ID" from dual;
               	end if;
       	end if;
end;
/
ALTER TRIGGER "DEAPP"."TRG_DE_RC_SNP_INFO_ID" ENABLE;
 
