--
-- Type: SEQUENCE; Owner: DEAPP; Name: DE_TWO_REGION_JUNCTION_SEQ
--
CREATE SEQUENCE  "DEAPP"."DE_TWO_REGION_JUNCTION_SEQ"  MINVALUE 1 MAXVALUE 9999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  NOORDER  NOCYCLE ;

--
-- Type: TABLE; Owner: DEAPP; Name: DE_TWO_REGION_JUNCTION
--
 CREATE TABLE "DEAPP"."DE_TWO_REGION_JUNCTION" 
  (	"TWO_REGION_JUNCTION_ID" NUMBER NOT NULL ENABLE, 
"UP_END" NUMBER(9,0) NOT NULL ENABLE, 
"UP_CHR" VARCHAR2(50 BYTE) NOT NULL ENABLE, 
"UP_POS" NUMBER(9,0) NOT NULL ENABLE, 
"UP_STRAND" CHAR(1 BYTE), 
"DOWN_END" NUMBER(9,0) NOT NULL ENABLE, 
"DOWN_CHR" VARCHAR2(50 BYTE) NOT NULL ENABLE, 
"DOWN_POS" NUMBER(9,0) NOT NULL ENABLE, 
"DOWN_STRAND" CHAR(1 BYTE), 
"IS_IN_FRAME" NUMBER(9,0), 
"EXTERNAL_ID" NUMBER(9,0), 
"ASSAY_ID" NUMBER(9,0), 
 CONSTRAINT "TWO_REGION_JUNCTION_ID" PRIMARY KEY ("TWO_REGION_JUNCTION_ID")
 USING INDEX
 TABLESPACE "TRANSMART"  ENABLE
  ) SEGMENT CREATION IMMEDIATE
 TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: DEAPP; Name: TR_JUNCTION_ASSAY
--
CREATE INDEX "DEAPP"."TR_JUNCTION_ASSAY" ON "DEAPP"."DE_TWO_REGION_JUNCTION" ("ASSAY_ID")
TABLESPACE "TRANSMART" ;

--
-- Type: TRIGGER; Owner: DEAPP; Name: TRG_DE_TWO_REGION_JUNCTION
--
  CREATE OR REPLACE TRIGGER "DEAPP"."TRG_DE_TWO_REGION_JUNCTION" 
before insert on "DEAPP"."DE_TWO_REGION_JUNCTION"
for each row begin
       	if inserting then
               	if :NEW."TWO_REGION_JUNCTION_ID" is null then
                       	select DE_TWO_REGION_JUNCTION_SEQ.nextval into :NEW."TWO_REGION_JUNCTION_ID" from dual;
               	end if;
       	end if;
end;
/
ALTER TRIGGER "DEAPP"."TRG_DE_TWO_REGION_JUNCTION" ENABLE;
 
--
-- Type: INDEX; Owner: DEAPP; Name: TR_JUNCTION_UP_CHR
--
CREATE INDEX "DEAPP"."TR_JUNCTION_UP_CHR" ON "DEAPP"."DE_TWO_REGION_JUNCTION" ("UP_CHR", "UP_POS")
TABLESPACE "TRANSMART" ;

--
-- Type: INDEX; Owner: DEAPP; Name: TR_JUNCTION_DOWN_CHR
--
CREATE INDEX "DEAPP"."TR_JUNCTION_DOWN_CHR" ON "DEAPP"."DE_TWO_REGION_JUNCTION" ("DOWN_CHR", "DOWN_POS")
TABLESPACE "TRANSMART" ;

