--
-- Type: TABLE; Owner: I2B2DEMODATA; Name: ARCHIVE_OBSERVATION_FACT
--
 CREATE TABLE "I2B2DEMODATA"."ARCHIVE_OBSERVATION_FACT" 
  (	"ENCOUNTER_NUM" NUMBER(38,0), 
"PATIENT_NUM" NUMBER(38,0), 
"CONCEPT_CD" VARCHAR2(50 BYTE), 
"PROVIDER_ID" VARCHAR2(50 BYTE), 
"START_DATE" TIMESTAMP (6), 
"MODIFIER_CD" VARCHAR2(100 BYTE), 
"INSTANCE_NUM" NUMBER(18,0), 
"VALTYPE_CD" VARCHAR2(50 BYTE), 
"TVAL_CHAR" VARCHAR2(255 BYTE), 
"NVAL_NUM" NUMBER(18,5), 
"VALUEFLAG_CD" VARCHAR2(50 BYTE), 
"QUANTITY_NUM" NUMBER(18,5), 
"UNITS_CD" VARCHAR2(50 BYTE), 
"END_DATE" TIMESTAMP (6), 
"LOCATION_CD" VARCHAR2(50 BYTE), 
"OBSERVATION_BLOB" CLOB, 
"CONFIDENCE_NUM" NUMBER(18,5), 
"UPDATE_DATE" TIMESTAMP (6), 
"DOWNLOAD_DATE" TIMESTAMP (6), 
"IMPORT_DATE" TIMESTAMP (6), 
"SOURCESYSTEM_CD" VARCHAR2(50 BYTE), 
"UPLOAD_ID" NUMBER(38,0), 
"ARCHIVE_UPLOAD_ID" NUMBER(22,0)
  ) SEGMENT CREATION DEFERRED
 TABLESPACE "TRANSMART" 
LOB ("OBSERVATION_BLOB") STORE AS BASICFILE (
 TABLESPACE "TRANSMART" ENABLE STORAGE IN ROW CHUNK 8192 RETENTION 
 NOCACHE LOGGING ) ;

--
-- Type: INDEX; Owner: I2B2DEMODATA; Name: PK_ARCHIVE_OBSFACT
--
CREATE INDEX "I2B2DEMODATA"."PK_ARCHIVE_OBSFACT" ON "I2B2DEMODATA"."ARCHIVE_OBSERVATION_FACT" ("ENCOUNTER_NUM", "PATIENT_NUM", "CONCEPT_CD", "PROVIDER_ID", "START_DATE", "MODIFIER_CD", "ARCHIVE_UPLOAD_ID")
TABLESPACE "TRANSMART" ;

